/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.InheretenceMethodRefactoring;
import org.acm.seguin.refactor.method.NearMissVisitor;
import org.acm.seguin.refactor.method.RemoveMethodFromSubclassVisitor;
import org.acm.seguin.refactor.method.RemoveMethodTransform;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class PushUpMethodRefactoring
extends InheretenceMethodRefactoring {
    private TypeSummary typeSummary;
    private TypeSummary parentType;

    protected PushUpMethodRefactoring() {
    }

    public String getDescription() {
        return "Moves a method " + this.methodSummary.getName() + " down into the parent class " + this.parentType.getName();
    }

    public int getID() {
        return 201;
    }

    protected void preconditions() throws RefactoringException {
        if (this.methodSummary == null) {
            throw new RefactoringException("No method specified");
        }
        this.typeSummary = (TypeSummary)this.methodSummary.getParent();
        TypeDeclSummary typeDeclSummary = this.typeSummary.getParentClass();
        this.parentType = GetTypeSummary.query(typeDeclSummary);
        this.checkDestination(this.parentType);
        this.checkDestinationFile(this.parentType, "Can't push up a method into source code that you don't have");
        NearMissVisitor nearMissVisitor = new NearMissVisitor(this.parentType, this.methodSummary, this.typeSummary);
        nearMissVisitor.visit(null);
        if (nearMissVisitor.getProblem() != null) {
            throw new RefactoringException("Method with a signature of " + nearMissVisitor.getProblem().toString() + " found in child of " + this.parentType.getName());
        }
    }

    protected void transform() {
        RemoveMethodTransform removeMethodTransform = new RemoveMethodTransform(this.methodSummary);
        ComplexTransform complexTransform = this.getComplexTransform();
        this.removeMethod(this.typeSummary, complexTransform, removeMethodTransform);
        SimpleNode simpleNode = removeMethodTransform.getMethodDeclaration();
        if (simpleNode == null) {
            return;
        }
        ASTMethodDeclaration aSTMethodDeclaration = this.updateMethod(simpleNode);
        this.addMethodToDest(complexTransform, removeMethodTransform, simpleNode, this.parentType);
        new RemoveMethodFromSubclassVisitor(this.parentType, this.methodSummary, this.typeSummary, complexTransform).visit(null);
    }
}

