/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.AddAbstractMethod;
import org.acm.seguin.refactor.method.InheretenceMethodRefactoring;
import org.acm.seguin.refactor.method.RemoveMethodTransform;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class PushDownMethodRefactoring
extends InheretenceMethodRefactoring {
    private LinkedList destinations = new LinkedList();
    private TypeSummary typeSummary;

    protected PushDownMethodRefactoring() {
    }

    public String getDescription() {
        return "Moves a method " + this.methodSummary.getName() + " down into the child classes of " + this.typeSummary.getName();
    }

    public int getID() {
        return 203;
    }

    public void addChild(TypeSummary typeSummary) {
        this.destinations.add(typeSummary);
    }

    protected void preconditions() throws RefactoringException {
        if (this.methodSummary == null) {
            throw new RefactoringException("No method specified");
        }
        this.typeSummary = (TypeSummary)this.methodSummary.getParent();
        Iterator iterator = this.destinations.iterator();
        while (iterator.hasNext()) {
            TypeSummary typeSummary = (TypeSummary)iterator.next();
            TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
            TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
            if (typeSummary2 != this.typeSummary) {
                throw new RefactoringException(typeSummary.getName() + " is not a subclass of " + this.typeSummary.getName());
            }
            this.checkDestination(typeSummary);
        }
    }

    protected void transform() {
        RemoveMethodTransform removeMethodTransform = new RemoveMethodTransform(this.methodSummary);
        ComplexTransform complexTransform = this.getComplexTransform();
        this.removeMethod(this.typeSummary, complexTransform, removeMethodTransform);
        SimpleNode simpleNode = removeMethodTransform.getMethodDeclaration();
        if (simpleNode == null) {
            return;
        }
        ASTMethodDeclaration aSTMethodDeclaration = this.updateMethod(simpleNode);
        Iterator iterator = this.destinations.iterator();
        while (iterator.hasNext()) {
            TypeSummary typeSummary = (TypeSummary)iterator.next();
            this.addMethodToDest(complexTransform, removeMethodTransform, simpleNode, typeSummary);
        }
    }

    protected void removeMethod(TypeSummary typeSummary, ComplexTransform complexTransform, RemoveMethodTransform removeMethodTransform) {
        complexTransform.add(new AddAbstractMethod(this.methodSummary));
        super.removeMethod(typeSummary, complexTransform, removeMethodTransform);
    }
}

