/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import org.acm.seguin.parser.ChildrenVisitor;
import org.acm.seguin.parser.ast.ASTArgumentList;
import org.acm.seguin.parser.ast.ASTArguments;
import org.acm.seguin.parser.ast.ASTExpression;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimaryExpression;
import org.acm.seguin.parser.ast.ASTPrimaryPrefix;
import org.acm.seguin.parser.ast.ASTPrimarySuffix;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTUnmodifiedClassDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.method.ObjectReference;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.LocalVariableSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.FieldQuery;

public class MoveMethodVisitor
extends ChildrenVisitor {
    private MethodSummary methodSummary;
    private TypeSummary typeSummary;
    private Summary destination;

    public MoveMethodVisitor(TypeSummary typeSummary, MethodSummary methodSummary, Summary summary) {
        this.typeSummary = typeSummary;
        this.methodSummary = methodSummary;
        this.destination = summary;
    }

    public Object visit(ASTUnmodifiedClassDeclaration aSTUnmodifiedClassDeclaration, Object object) {
        return object;
    }

    public Object visit(ASTUnmodifiedInterfaceDeclaration aSTUnmodifiedInterfaceDeclaration, Object object) {
        return object;
    }

    public Object visit(ASTFormalParameters aSTFormalParameters, Object object) {
        if (this.destination instanceof ParameterSummary) {
            SimpleNode simpleNode;
            ASTFormalParameter aSTFormalParameter;
            String string = this.destination.getName();
            int n = aSTFormalParameters.jjtGetNumChildren();
            int n2 = 0;
            while (n2 < n) {
                aSTFormalParameter = (ASTFormalParameter)aSTFormalParameters.jjtGetChild(n2);
                simpleNode = (ASTVariableDeclaratorId)aSTFormalParameter.jjtGetChild(1);
                if (((ASTVariableDeclaratorId)simpleNode).getName().equals(string)) {
                    aSTFormalParameters.jjtDeleteChild(n2);
                    --n2;
                    --n;
                }
                ++n2;
            }
            if (ObjectReference.isReferenced(this.methodSummary)) {
                aSTFormalParameter = new ASTFormalParameter(0);
                simpleNode = new ASTType(0);
                aSTFormalParameter.jjtAddChild(simpleNode, 0);
                ASTName aSTName = new ASTName(0);
                String string2 = this.typeSummary.getName();
                aSTName.addNamePart(string2);
                simpleNode.jjtAddChild(aSTName, 0);
                ASTVariableDeclaratorId aSTVariableDeclaratorId = new ASTVariableDeclaratorId(0);
                aSTVariableDeclaratorId.setName(string2.substring(0, 1).toLowerCase() + string2.substring(1));
                aSTFormalParameter.jjtAddChild(aSTVariableDeclaratorId, 1);
                n = aSTFormalParameters.jjtGetNumChildren();
                aSTFormalParameters.jjtAddChild(aSTFormalParameter, n);
            }
        }
        return object;
    }

    public Object visit(ASTExpression aSTExpression, Object object) {
        if (aSTExpression.jjtGetNumChildren() > 1) {
            Object object2 = super.visit(aSTExpression, (Object)Boolean.TRUE);
            if (object2 != null) {
                ASTArguments aSTArguments = (ASTArguments)object2;
                ASTArgumentList aSTArgumentList = new ASTArgumentList(0);
                aSTArguments.jjtAddChild(aSTArgumentList, 0);
                aSTArgumentList.jjtAddChild(aSTExpression.jjtGetChild(2), 0);
                aSTExpression.jjtDeleteChild(2);
                aSTExpression.jjtDeleteChild(1);
            }
            return null;
        }
        return super.visit(aSTExpression, (Object)Boolean.FALSE);
    }

    public Object visit(ASTPrimaryExpression aSTPrimaryExpression, Object object) {
        Object object2 = null;
        if (this.destination instanceof ParameterSummary) {
            ASTName aSTName;
            String string = this.destination.getName();
            ASTPrimaryPrefix aSTPrimaryPrefix = (ASTPrimaryPrefix)aSTPrimaryExpression.jjtGetChild(0);
            if ("this".equals(aSTPrimaryPrefix.getName())) {
                ASTName aSTName2 = new ASTName(0);
                aSTName2.addNamePart(this.getReplacementVariableName());
                aSTPrimaryPrefix.jjtAddChild(aSTName2, 0);
            } else if (this.isMethod(aSTPrimaryExpression, aSTPrimaryPrefix)) {
                this.updatePrimaryPrefix(aSTPrimaryPrefix, string);
            } else if (this.isVariable(aSTPrimaryExpression, aSTPrimaryPrefix) && !this.isLocalVariable((aSTName = (ASTName)aSTPrimaryPrefix.jjtGetChild(0)).getNamePart(0))) {
                Boolean bl = (Boolean)object;
                object2 = this.updatePrivateField(aSTPrimaryExpression, aSTPrimaryPrefix, aSTName, string, bl);
            }
        }
        super.visit(aSTPrimaryExpression, object);
        return object2;
    }

    private boolean isMethod(ASTPrimaryExpression aSTPrimaryExpression, ASTPrimaryPrefix aSTPrimaryPrefix) {
        return aSTPrimaryExpression.jjtGetNumChildren() > 1 && aSTPrimaryExpression.jjtGetChild(1).jjtGetChild(0) instanceof ASTArguments && aSTPrimaryPrefix.jjtGetChild(0) instanceof ASTName;
    }

    private boolean isVariable(ASTPrimaryExpression aSTPrimaryExpression, ASTPrimaryPrefix aSTPrimaryPrefix) {
        return aSTPrimaryExpression.jjtGetNumChildren() == 1 && aSTPrimaryPrefix.jjtGetChild(0) instanceof ASTName;
    }

    private boolean isLocalVariable(String string) {
        Iterator iterator = this.methodSummary.getDependencies();
        if (iterator != null) {
            while (iterator.hasNext()) {
                LocalVariableSummary localVariableSummary;
                Summary summary = (Summary)iterator.next();
                if (!(summary instanceof LocalVariableSummary) || !(localVariableSummary = (LocalVariableSummary)summary).getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private String getFieldGetter(FieldSummary fieldSummary) {
        String string = fieldSummary.getType();
        String string2 = "get";
        if (string.equalsIgnoreCase("boolean")) {
            string2 = "is";
        }
        String string3 = fieldSummary.getName();
        return string2 + string3.substring(0, 1).toUpperCase() + string3.substring(1);
    }

    private String getFieldSetter(FieldSummary fieldSummary) {
        String string = "set";
        String string2 = fieldSummary.getName();
        return string + string2.substring(0, 1).toUpperCase() + string2.substring(1);
    }

    private void updatePrimaryPrefix(ASTPrimaryPrefix aSTPrimaryPrefix, String string) {
        ASTName aSTName = (ASTName)aSTPrimaryPrefix.jjtGetChild(0);
        if (aSTName.getNameSize() == 1) {
            this.updateLocalReferences(aSTPrimaryPrefix, aSTName);
        } else if (aSTName.getNameSize() == 2 && aSTName.getNamePart(0).equals(string)) {
            this.updateParameterReferences(aSTPrimaryPrefix, aSTName);
        }
    }

    private void updateLocalReferences(ASTPrimaryPrefix aSTPrimaryPrefix, ASTName aSTName) {
        ASTName aSTName2 = new ASTName(0);
        aSTName2.addNamePart(this.getReplacementVariableName());
        aSTName2.addNamePart(aSTName.getNamePart(0));
        aSTPrimaryPrefix.jjtAddChild(aSTName2, 0);
    }

    private String getReplacementVariableName() {
        String string = this.typeSummary.getName();
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private void updateParameterReferences(ASTPrimaryPrefix aSTPrimaryPrefix, ASTName aSTName) {
        ASTName aSTName2 = new ASTName(0);
        aSTName2.addNamePart(aSTName.getNamePart(1));
        aSTPrimaryPrefix.jjtAddChild(aSTName2, 0);
    }

    private Object updatePrivateField(ASTPrimaryExpression aSTPrimaryExpression, ASTPrimaryPrefix aSTPrimaryPrefix, ASTName aSTName, String string, boolean bl) {
        String string2;
        FieldSummary fieldSummary;
        if (aSTName.getNameSize() == 1 && (fieldSummary = FieldQuery.find(this.typeSummary, string2 = aSTName.getNamePart(0))).getModifiers().isPrivate()) {
            ASTName aSTName2 = new ASTName(0);
            aSTName2.addNamePart(this.getReplacementVariableName());
            aSTName2.addNamePart(bl ? this.getFieldSetter(fieldSummary) : this.getFieldGetter(fieldSummary));
            aSTPrimaryPrefix.jjtAddChild(aSTName2, 0);
            ASTPrimarySuffix aSTPrimarySuffix = new ASTPrimarySuffix(0);
            ASTArguments aSTArguments = new ASTArguments(0);
            aSTPrimarySuffix.jjtAddChild(aSTArguments, 0);
            aSTPrimaryExpression.jjtInsertChild(aSTPrimarySuffix, 1);
            return aSTArguments;
        }
        this.updatePrimaryPrefix(aSTPrimaryPrefix, string);
        return null;
    }
}

