/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTArgumentList;
import org.acm.seguin.parser.ast.ASTArguments;
import org.acm.seguin.parser.ast.ASTAssignmentOperator;
import org.acm.seguin.parser.ast.ASTBlockStatement;
import org.acm.seguin.parser.ast.ASTExpression;
import org.acm.seguin.parser.ast.ASTLocalVariableDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimaryExpression;
import org.acm.seguin.parser.ast.ASTPrimaryPrefix;
import org.acm.seguin.parser.ast.ASTPrimarySuffix;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTStatement;
import org.acm.seguin.parser.ast.ASTStatementExpression;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTVariableDeclarator;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.ASTVariableInitializer;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.build.BuildExpression;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.VariableSummary;

class EMBuilder {
    private String methodName;
    private boolean isStatement;
    private LinkedList parameters;
    private VariableSummary returnSummary = null;
    private boolean localVariableNeeded = false;

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public void setStatement(boolean bl) {
        this.isStatement = bl;
    }

    public void setParameters(LinkedList linkedList) {
        this.parameters = linkedList;
    }

    public void setReturnSummary(VariableSummary variableSummary) {
        this.returnSummary = variableSummary;
    }

    public void setLocalVariableNeeded(boolean bl) {
        this.localVariableNeeded = bl;
    }

    public Node build() {
        ASTBlockStatement aSTBlockStatement = new ASTBlockStatement(0);
        if (this.localVariableNeeded) {
            this.buildWithLocal(aSTBlockStatement);
            return aSTBlockStatement;
        }
        ASTStatement aSTStatement = new ASTStatement(0);
        aSTBlockStatement.jjtAddChild(aSTStatement, 0);
        ASTStatementExpression aSTStatementExpression = new ASTStatementExpression(0);
        aSTStatement.jjtAddChild(aSTStatementExpression, 0);
        ASTPrimaryExpression aSTPrimaryExpression = null;
        if (this.isStatement && this.returnSummary != null) {
            this.buildAssignment(aSTStatementExpression);
        } else {
            aSTPrimaryExpression = this.buildMethodInvocation(aSTStatementExpression, 0);
        }
        if (this.isStatement) {
            return aSTBlockStatement;
        }
        return aSTPrimaryExpression;
    }

    private void buildAssignment(ASTStatementExpression aSTStatementExpression) {
        ASTPrimaryExpression aSTPrimaryExpression = new ASTPrimaryExpression(0);
        aSTStatementExpression.jjtAddChild(aSTPrimaryExpression, 0);
        ASTPrimaryPrefix aSTPrimaryPrefix = new ASTPrimaryPrefix(0);
        aSTPrimaryExpression.jjtAddChild(aSTPrimaryPrefix, 0);
        ASTName aSTName = new ASTName(0);
        aSTName.addNamePart(this.returnSummary.getName());
        aSTPrimaryExpression.jjtAddChild(aSTName, 0);
        ASTAssignmentOperator aSTAssignmentOperator = new ASTAssignmentOperator(0);
        aSTAssignmentOperator.setName("=");
        aSTStatementExpression.jjtAddChild(aSTAssignmentOperator, 1);
        this.buildMethodInvocation(aSTStatementExpression, 2);
    }

    private ASTPrimaryExpression buildMethodInvocation(SimpleNode simpleNode, int n) {
        ASTPrimaryExpression aSTPrimaryExpression = new ASTPrimaryExpression(0);
        simpleNode.jjtAddChild(aSTPrimaryExpression, n);
        ASTPrimaryPrefix aSTPrimaryPrefix = new ASTPrimaryPrefix(0);
        aSTPrimaryExpression.jjtAddChild(aSTPrimaryPrefix, 0);
        ASTName aSTName = new ASTName(0);
        aSTName.addNamePart(this.methodName);
        aSTPrimaryExpression.jjtAddChild(aSTName, 0);
        ASTPrimarySuffix aSTPrimarySuffix = new ASTPrimarySuffix(0);
        aSTPrimaryExpression.jjtAddChild(aSTPrimarySuffix, 1);
        ASTArguments aSTArguments = new ASTArguments(0);
        aSTPrimarySuffix.jjtAddChild(aSTArguments, 0);
        ASTArgumentList aSTArgumentList = new ASTArgumentList(0);
        aSTArguments.jjtAddChild(aSTArgumentList, 0);
        int n2 = 0;
        BuildExpression buildExpression = new BuildExpression();
        Iterator iterator = this.parameters.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                VariableSummary variableSummary = (VariableSummary)iterator.next();
                ASTExpression aSTExpression = buildExpression.buildName(variableSummary.getName());
                aSTArgumentList.jjtAddChild(aSTExpression, n2);
                ++n2;
            }
        }
        return aSTPrimaryExpression;
    }

    private void buildWithLocal(ASTBlockStatement aSTBlockStatement) {
        SimpleNode simpleNode;
        ASTLocalVariableDeclaration aSTLocalVariableDeclaration = new ASTLocalVariableDeclaration(0);
        aSTBlockStatement.jjtAddChild(aSTLocalVariableDeclaration, 0);
        ASTType aSTType = new ASTType(0);
        aSTLocalVariableDeclaration.jjtAddChild(aSTType, 0);
        TypeDeclSummary typeDeclSummary = this.returnSummary.getTypeDecl();
        aSTType.setArrayCount(typeDeclSummary.getArrayCount());
        if (typeDeclSummary.isPrimitive()) {
            simpleNode = new ASTPrimitiveType(0);
            ((ASTPrimitiveType)simpleNode).setName(typeDeclSummary.getType());
            aSTType.jjtAddChild(simpleNode, 0);
        } else {
            simpleNode = new ASTName(0);
            ((ASTName)simpleNode).fromString(typeDeclSummary.getLongName());
            aSTType.jjtAddChild(simpleNode, 0);
        }
        simpleNode = new ASTVariableDeclarator(0);
        aSTLocalVariableDeclaration.jjtAddChild(simpleNode, 1);
        ASTVariableDeclaratorId aSTVariableDeclaratorId = new ASTVariableDeclaratorId(0);
        aSTVariableDeclaratorId.setName(this.returnSummary.getName());
        simpleNode.jjtAddChild(aSTVariableDeclaratorId, 0);
        ASTVariableInitializer aSTVariableInitializer = new ASTVariableInitializer(0);
        simpleNode.jjtAddChild(aSTVariableInitializer, 1);
        this.buildMethodInvocation(aSTVariableInitializer, 0);
    }
}

