/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import java.util.Iterator;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.field.FieldRefactoring;
import org.acm.seguin.refactor.field.RenameFieldData;
import org.acm.seguin.refactor.field.RenameFieldTransform;
import org.acm.seguin.refactor.field.RenameSystemTraversal;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;

public class RenameFieldRefactoring
extends FieldRefactoring {
    private String newName;
    private FieldSummary oldField;

    public void setNewName(String string) {
        this.newName = string;
    }

    public String getDescription() {
        return "Renames the field " + this.field + " to " + this.newName;
    }

    public int getID() {
        return 103;
    }

    protected void preconditions() throws RefactoringException {
        Iterator iterator = this.typeSummary.getFields();
        if (iterator == null) {
            throw new RefactoringException(this.typeSummary.getName() + " has no fields associated with it, so it cannot be renamed");
        }
        boolean bl = false;
        while (iterator.hasNext()) {
            FieldSummary fieldSummary = (FieldSummary)iterator.next();
            if (fieldSummary.getName().equals(this.field)) {
                bl = true;
                this.oldField = fieldSummary;
            }
            if (!fieldSummary.getName().equals(this.newName)) continue;
            throw new RefactoringException("A field named " + this.newName + " already exists in class " + this.typeSummary.getName());
        }
        if (!bl) {
            throw new RefactoringException("No field named " + this.field + " is contained in " + this.typeSummary.getName());
        }
    }

    protected void transform() {
        FileSummary fileSummary = this.getFileSummary(this.typeSummary);
        RenameFieldTransform renameFieldTransform = new RenameFieldTransform(this.oldField, this.newName);
        ComplexTransform complexTransform = this.getComplexTransform();
        complexTransform.add(renameFieldTransform);
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
        if (!this.oldField.getModifiers().isPrivate()) {
            if (this.oldField.getModifiers().isPackage()) {
                RenameSystemTraversal renameSystemTraversal = new RenameSystemTraversal();
                renameSystemTraversal.visit(this.getPackage(), (Object)new RenameFieldData(this.oldField, this.newName, complexTransform));
            } else {
                RenameSystemTraversal renameSystemTraversal = new RenameSystemTraversal();
                renameSystemTraversal.visit(new RenameFieldData(this.oldField, this.newName, complexTransform));
            }
        }
    }

    private PackageSummary getPackage() {
        Summary summary = this.oldField;
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        return (PackageSummary)summary;
    }
}

