/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import org.acm.seguin.parser.ChildrenVisitor;
import org.acm.seguin.parser.ast.ASTClassBody;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceBody;
import org.acm.seguin.parser.ast.ASTInterfaceMemberDeclaration;
import org.acm.seguin.parser.ast.ASTNestedClassDeclaration;
import org.acm.seguin.parser.ast.ASTNestedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTVariableDeclarator;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;

public class RemoveFieldVisitor
extends ChildrenVisitor {
    private String fieldName;
    private SimpleNode fieldDecl;

    public RemoveFieldVisitor(String string) {
        this.fieldName = string;
        this.fieldDecl = null;
    }

    public SimpleNode getFieldDeclaration() {
        return this.fieldDecl;
    }

    public Object visit(ASTClassBody aSTClassBody, Object object) {
        Object object2 = this.removeField(aSTClassBody);
        if (object2 == null) {
            object2 = super.visit(aSTClassBody, object);
        }
        return object2;
    }

    public Object visit(ASTInterfaceBody aSTInterfaceBody, Object object) {
        Object object2 = this.removeField(aSTInterfaceBody);
        if (object2 == null) {
            object2 = super.visit(aSTInterfaceBody, object);
        }
        return object2;
    }

    public Object visit(ASTNestedClassDeclaration aSTNestedClassDeclaration, Object object) {
        return null;
    }

    public Object visit(ASTNestedInterfaceDeclaration aSTNestedInterfaceDeclaration, Object object) {
        return null;
    }

    private boolean isFound(SimpleNode simpleNode) {
        if (!(simpleNode instanceof ASTFieldDeclaration)) {
            return false;
        }
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 1;
        while (n2 < n) {
            if (this.checkDeclaration(simpleNode, n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isMultiple(SimpleNode simpleNode) {
        return simpleNode.jjtGetNumChildren() > 2;
    }

    private Object removeField(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(n2);
            SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(0);
            if (this.isFound(simpleNode3)) {
                if (this.isMultiple(simpleNode3)) {
                    this.removeMultiple((ASTFieldDeclaration)simpleNode3, simpleNode2 instanceof ASTClassBodyDeclaration);
                } else {
                    this.removeSingle(simpleNode, simpleNode2, n2);
                }
                return simpleNode2;
            }
            ++n2;
        }
        return null;
    }

    private void removeSingle(SimpleNode simpleNode, SimpleNode simpleNode2, int n) {
        this.fieldDecl = simpleNode2;
        simpleNode.jjtDeleteChild(n);
    }

    private void removeMultiple(ASTFieldDeclaration aSTFieldDeclaration, boolean bl) {
        this.fieldDecl = bl ? new ASTClassBodyDeclaration(0) : new ASTInterfaceMemberDeclaration(0);
        ASTFieldDeclaration aSTFieldDeclaration2 = new ASTFieldDeclaration(0);
        this.fieldDecl.jjtInsertChild(aSTFieldDeclaration2, 0);
        aSTFieldDeclaration2.jjtInsertChild(aSTFieldDeclaration.jjtGetChild(0), 0);
        int n = aSTFieldDeclaration.jjtGetNumChildren();
        int n2 = 1;
        while (n2 < n) {
            if (this.checkDeclaration(aSTFieldDeclaration, n2)) {
                aSTFieldDeclaration2.jjtInsertChild(aSTFieldDeclaration.jjtGetChild(n2), 1);
                aSTFieldDeclaration.jjtDeleteChild(n2);
                return;
            }
            ++n2;
        }
    }

    private boolean checkDeclaration(SimpleNode simpleNode, int n) {
        ASTVariableDeclarator aSTVariableDeclarator = (ASTVariableDeclarator)simpleNode.jjtGetChild(n);
        ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTVariableDeclarator.jjtGetChild(0);
        return aSTVariableDeclaratorId.getName().equals(this.fieldName);
    }
}

