/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.field.AddFieldTransform;
import org.acm.seguin.refactor.field.FieldRefactoring;
import org.acm.seguin.refactor.field.RemoveFieldFromSubclassVisitor;
import org.acm.seguin.refactor.field.RemoveFieldTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.FieldQuery;
import org.acm.seguin.summary.query.GetTypeSummary;

public class PushUpFieldRefactoring
extends FieldRefactoring {
    private TypeSummary parentType;

    protected PushUpFieldRefactoring() {
    }

    public String getDescription() {
        return "Moves a field " + this.field + " into parent class named " + this.parentType.getName();
    }

    public int getID() {
        return 102;
    }

    protected void preconditions() throws RefactoringException {
        if (this.field == null) {
            throw new RefactoringException("No field specified");
        }
        if (this.typeSummary == null) {
            throw new RefactoringException("No type specified");
        }
        if (FieldQuery.query(this.typeSummary, this.field, 1) == null) {
            throw new RefactoringException("Field named " + this.field + " does not exist in " + this.typeSummary.getName());
        }
        TypeDeclSummary typeDeclSummary = this.typeSummary.getParentClass();
        this.parentType = GetTypeSummary.query(typeDeclSummary);
        if (this.parentType == null) {
            throw new RefactoringException("Can't push up a field into source code that you don't have");
        }
        this.checkDestinationFile(this.parentType, "Can't push up a field into source code that you don't have");
        if (FieldQuery.query(this.parentType, this.field, 1) != null) {
            throw new RefactoringException("Field named " + this.field + " already exists in parent class");
        }
        if (FieldQuery.queryAncestors(this.typeSummary, this.field, 1) != null) {
            throw new RefactoringException("Field named " + this.field + " already exists in an ancestor class");
        }
        if (((FileSummary)this.parentType.getParent()).getFile() == null) {
            throw new RefactoringException("Can't push up a field into source code that you don't have");
        }
        if (((FileSummary)this.typeSummary.getParent()).getFile() == null) {
            throw new RefactoringException("Can't push up a field from source code that you don't have");
        }
    }

    protected void transform() {
        FileSummary fileSummary = this.getFileSummary(this.typeSummary);
        RemoveFieldTransform removeFieldTransform = new RemoveFieldTransform(this.field);
        ComplexTransform complexTransform = this.getComplexTransform();
        complexTransform.add(removeFieldTransform);
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
        SimpleNode simpleNode = removeFieldTransform.getFieldDeclaration();
        if (simpleNode == null) {
            return;
        }
        ASTFieldDeclaration aSTFieldDeclaration = (ASTFieldDeclaration)simpleNode.jjtGetChild(0);
        ModifierHolder modifierHolder = aSTFieldDeclaration.getModifiers();
        if (!modifierHolder.isPublic()) {
            modifierHolder.setPrivate(false);
            modifierHolder.setProtected(true);
        }
        AddFieldTransform addFieldTransform = new AddFieldTransform(simpleNode);
        complexTransform.clear();
        complexTransform.add(addFieldTransform);
        Object object = this.getFieldType(simpleNode, fileSummary);
        if (object != null) {
            if (object instanceof TypeSummary && !this.isInJavaLang((TypeSummary)object)) {
                complexTransform.add(new AddImportTransform((TypeSummary)object));
            } else if (object instanceof ASTName && !this.isInJavaLang((ASTName)object)) {
                complexTransform.add(new AddImportTransform((ASTName)object));
            }
        }
        FileSummary fileSummary2 = (FileSummary)this.parentType.getParent();
        complexTransform.apply(fileSummary2.getFile(), fileSummary2.getFile());
        new RemoveFieldFromSubclassVisitor(this.parentType, this.typeSummary.getField(this.field), this.typeSummary, complexTransform).visit(null);
    }
}

