/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

abstract class FieldRefactoring
extends Refactoring {
    protected String field;
    protected TypeSummary typeSummary;

    public void setClass(String string, String string2) {
        this.setClass(GetTypeSummary.query(PackageSummary.getPackageSummary(string), string2));
    }

    public void setClass(TypeSummary typeSummary) {
        this.typeSummary = typeSummary;
    }

    public void setField(String string) {
        this.field = string;
    }

    protected boolean isInJavaLang(ASTName aSTName) {
        return aSTName.getNameSize() == 3 && aSTName.getNamePart(0).equals("java") && aSTName.getNamePart(1).equals("lang");
    }

    protected boolean isInJavaLang(TypeSummary typeSummary) {
        return this.getPackage(typeSummary).getName().equals("java.lang");
    }

    protected PackageSummary getPackage(Summary summary) {
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        return (PackageSummary)summary;
    }

    protected FileSummary getFileSummary(Summary summary) {
        while (!(summary instanceof FileSummary)) {
            summary = summary.getParent();
        }
        return (FileSummary)summary;
    }

    protected Object getFieldType(SimpleNode simpleNode, FileSummary fileSummary) {
        ASTFieldDeclaration aSTFieldDeclaration = (ASTFieldDeclaration)simpleNode.jjtGetChild(0);
        ASTType aSTType = (ASTType)aSTFieldDeclaration.jjtGetChild(0);
        if (aSTType.jjtGetChild(0) instanceof ASTPrimitiveType) {
            return null;
        }
        ASTName aSTName = (ASTName)aSTType.jjtGetChild(0);
        if (aSTName.getNameSize() == 1) {
            return GetTypeSummary.query(fileSummary, aSTName.getName());
        }
        return aSTName;
    }
}

