/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.NameFactory;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.summary.PackageSummary;

public class RemoveImportTransform
extends TransformAST {
    private ASTName name;
    private boolean packageImport;

    public RemoveImportTransform(ASTName aSTName) {
        this.name = aSTName;
        this.packageImport = false;
    }

    public RemoveImportTransform(String string, String string2) {
        this.name = NameFactory.getName(string, string2);
        this.packageImport = false;
    }

    public RemoveImportTransform(PackageSummary packageSummary) {
        this.name = new ASTName(0);
        this.name.fromString(packageSummary.getName());
        this.packageImport = true;
    }

    public void update(SimpleNode simpleNode) {
        int n = 0;
        while (n < simpleNode.jjtGetNumChildren()) {
            if (this.isInvalid((SimpleNode)simpleNode.jjtGetChild(n))) {
                simpleNode.jjtDeleteChild(n);
                continue;
            }
            ++n;
        }
    }

    protected boolean isInvalid(SimpleNode simpleNode) {
        if (simpleNode instanceof ASTImportDeclaration) {
            ASTImportDeclaration aSTImportDeclaration = (ASTImportDeclaration)simpleNode;
            if (!this.packageImport) {
                return aSTImportDeclaration.jjtGetChild(0).equals(this.name);
            }
            ASTName aSTName = (ASTName)aSTImportDeclaration.jjtGetChild(0);
            String string = aSTName.getName();
            String string2 = this.name.getName();
            return string.equals(string2);
        }
        return false;
    }
}

