/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.refactor.undo.UndoAction;
import org.acm.seguin.version.VersionControl;
import org.acm.seguin.version.VersionControlFactory;

public class ComplexTransform {
    private ArrayList transforms = new ArrayList();
    private UndoAction undo;

    public ComplexTransform(UndoAction undoAction) {
        this.undo = undoAction;
    }

    public void add(TransformAST transformAST) {
        if (transformAST != null) {
            this.transforms.add(transformAST);
        }
    }

    public void clear() {
        this.transforms.clear();
    }

    public boolean hasAnyChanges() {
        return this.transforms.size() > 0;
    }

    public void apply(File file, File file2) {
        FileParserFactory fileParserFactory = new FileParserFactory(file);
        SimpleNode simpleNode = fileParserFactory.getAbstractSyntaxTree(false);
        int n = this.transforms.size();
        int n2 = 0;
        while (n2 < n) {
            TransformAST transformAST = (TransformAST)this.transforms.get(n2);
            transformAST.update(simpleNode);
            ++n2;
        }
        if (!file.canWrite()) {
            this.checkOut(file);
        }
        this.undo.add(file, file2);
        this.createParent(file2);
        try {
            new PrettyPrintFile().apply(file2, simpleNode);
        }
        catch (Throwable throwable) {
            ExceptionPrinter.print(throwable, false);
        }
    }

    public void createFile(File file) {
        this.undo.add(null, file);
    }

    public void removeFile(File file) {
        this.undo.add(file, null);
    }

    private void createParent(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    private void checkOut(File file) {
        String string;
        VersionControl versionControl = VersionControlFactory.get();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        versionControl.checkOut(string);
    }
}

