/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTImportDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.NameFactory;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;

public class AddImportTransform
extends TransformAST {
    private ASTName name;
    private boolean ignorePackageName;

    public AddImportTransform(ASTName aSTName) {
        this.name = aSTName;
        this.ignorePackageName = false;
    }

    public AddImportTransform(String string, String string2) {
        this.name = NameFactory.getName(string, string2);
        this.ignorePackageName = false;
    }

    public AddImportTransform(TypeSummary typeSummary) {
        Summary summary = typeSummary;
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        PackageSummary packageSummary = (PackageSummary)summary;
        this.name = NameFactory.getName(packageSummary.getName(), typeSummary.getName());
        this.ignorePackageName = false;
    }

    public void setIgnorePackageName(boolean bl) {
        this.ignorePackageName = bl;
    }

    public void update(SimpleNode simpleNode) {
        if (this.name.getNameSize() == 3 && this.name.getNamePart(0).equals("java") && this.name.getNamePart(1).equals("lang")) {
            return;
        }
        int n = this.findLastImport(simpleNode);
        if (n == -1) {
            return;
        }
        ASTImportDeclaration aSTImportDeclaration = new ASTImportDeclaration(0);
        aSTImportDeclaration.jjtAddChild(this.name, 0);
        aSTImportDeclaration.setImportPackage(false);
        simpleNode.jjtInsertChild(aSTImportDeclaration, n);
    }

    protected int findLastImport(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            ASTName aSTName;
            SimpleNode simpleNode2;
            Node node = simpleNode.jjtGetChild(n2);
            if (!this.ignorePackageName && node instanceof ASTPackageDeclaration) {
                simpleNode2 = (ASTPackageDeclaration)node;
                aSTName = (ASTName)node.jjtGetChild(0);
                if (aSTName.getNameSize() + 1 == this.name.getNameSize()) {
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < aSTName.getNameSize()) {
                        if (!aSTName.getNamePart(n3).equals(this.name.getNamePart(n3))) {
                            bl = false;
                        }
                        ++n3;
                    }
                    if (bl) {
                        return -1;
                    }
                }
            }
            if (node instanceof ASTImportDeclaration) {
                simpleNode2 = (ASTImportDeclaration)node;
                aSTName = (ASTName)node.jjtGetChild(0);
                if (aSTName.equals(this.name)) {
                    return -1;
                }
            }
            if (simpleNode.jjtGetChild(n2) instanceof ASTTypeDeclaration) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

