/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.LineSet;
import org.acm.seguin.util.TextFormatter;

public class PropertyLinePrinter
extends LinePrinter {
    private Font lineNo = null;
    private Font normal = null;
    private Font keyword = null;
    private Font comment = null;

    public void setFontSize(int n) {
        if (this.fontSize != n) {
            super.setFontSize(n);
            this.normal = null;
            this.keyword = null;
            this.comment = null;
            this.lineNo = null;
        }
    }

    public void init(Graphics graphics) {
        if (this.normal == null) {
            this.normal = new Font("SansSerif", 0, this.fontSize);
            this.keyword = new Font("SansSerif", 1, this.fontSize);
            this.comment = new Font("SansSerif", 2, this.fontSize);
            this.lineNo = new Font("Monospaced", 0, this.fontSize);
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.normal);
    }

    public void print(Graphics graphics, String string, int n, int n2, LineSet lineSet, int n3) {
        String string2 = TextFormatter.rightJustifyNumber(n3 + 1, 5) + ":  ";
        graphics.setFont(this.lineNo);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string2, n, n2);
        n += fontMetrics.stringWidth(string2);
        if (string.length() < 1) {
            return;
        }
        if (string.charAt(0) == '#') {
            graphics.setFont(this.comment);
            graphics.drawString(string, n, n2);
            return;
        }
        int n4 = string.indexOf(61);
        if (n4 > 0) {
            String string3 = string.substring(0, n4);
            String string4 = string.substring(n4 + 1);
            graphics.setFont(this.keyword);
            graphics.drawString(string3, n, n2);
            fontMetrics = graphics.getFontMetrics();
            graphics.setColor(Color.gray);
            graphics.drawString("=", n += fontMetrics.stringWidth(string3), n2);
            graphics.setFont(this.normal);
            graphics.setColor(Color.black);
            graphics.drawString(string4, n += fontMetrics.stringWidth("="), n2);
            return;
        }
        graphics.drawString(string, n, n2);
    }
}

