/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrintingSettings {
    private int textFontSize;
    private int textSpace;
    private int headerBlock;
    private int filenameFont;
    private int dateFont;
    private int linesPerPage;

    public PrintingSettings() {
        this.init();
    }

    public void setTextFontSize(int n) {
        if (n != this.textFontSize) {
            this.textFontSize = n;
            this.save();
        }
    }

    public void setTextSpace(int n) {
        if (n != this.textSpace) {
            this.textSpace = n;
            this.save();
        }
    }

    public void setHeaderBlockHeight(int n) {
        if (n != this.headerBlock) {
            this.headerBlock = n;
            this.save();
        }
    }

    public void setFilenameFontSize(int n) {
        if (n != this.filenameFont) {
            this.filenameFont = n;
            this.save();
        }
    }

    public void setDateFontSize(int n) {
        if (n != this.dateFont) {
            this.dateFont = n;
            this.save();
        }
    }

    public void setLinesPerPage(int n) {
        if (this.linesPerPage != n) {
            this.linesPerPage = n;
            this.save();
        }
    }

    public int getTextFontSize() {
        return this.textFontSize;
    }

    public int getTextSpace() {
        return this.textSpace;
    }

    public int getHeaderBlockHeight() {
        return this.headerBlock;
    }

    public int getFilenameFontSize() {
        return this.filenameFont;
    }

    public int getDateFontSize() {
        return this.dateFont;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public void save() {
        try {
            String string = FileSettings.getSettingsRoot() + File.separator + ".Refactory";
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string2 = string + File.separator + "printing.settings";
            FileWriter fileWriter = new FileWriter(string2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.write(printWriter);
            printWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    private void defaults() {
        this.textFontSize = 10;
        this.textSpace = 0;
        this.headerBlock = 30;
        this.filenameFont = 14;
        this.dateFont = 8;
        this.linesPerPage = 36;
    }

    private void init() {
        this.defaults();
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "printing");
            this.textFontSize = fileSettings.getInteger("text.font.size");
            this.textSpace = fileSettings.getInteger("text.space");
            this.headerBlock = fileSettings.getInteger("header.space");
            this.filenameFont = fileSettings.getInteger("filename.font.size");
            this.dateFont = fileSettings.getInteger("date.font.size");
            this.linesPerPage = fileSettings.getInteger("lines.per.page");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }

    private void write(PrintWriter printWriter) {
        printWriter.println("#  This is the font size for the text of the file");
        printWriter.println("text.font.size=" + this.textFontSize);
        printWriter.println(" ");
        printWriter.println("#  This is the number of pixels to skip between");
        printWriter.println("#  lines in the text of the file");
        printWriter.println("text.space=" + this.textSpace);
        printWriter.println(" ");
        printWriter.println("#  The header block is 30 pixels high");
        printWriter.println("header.space=" + this.headerBlock);
        printWriter.println(" ");
        printWriter.println("#  The name of the file is specified with this parameter");
        printWriter.println("filename.font.size=" + this.filenameFont);
        printWriter.println(" ");
        printWriter.println("#  The date that the file was printed and the number");
        printWriter.println("#  of pages is in this font size");
        printWriter.println("date.font.size=" + this.dateFont);
        printWriter.println(" ");
        printWriter.println("#  The number of lines on a page.  This is an estimate");
        printWriter.println("#  that is updated by the software each time a new set of");
        printWriter.println("#  values is changed");
        printWriter.println("lines.per.page=" + this.linesPerPage);
    }
}

