/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTInterfaceMemberDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTNestedClassDeclaration;
import org.acm.seguin.parser.ast.ASTNestedInterfaceDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.sort.Ordering;

public class ProtectionOrder
extends Ordering {
    private boolean publicFirst;
    private static final int PUBLIC = 1;
    private static final int PROTECTED = 2;
    private static final int PACKAGE = 3;
    private static final int PRIVATE = 4;

    public ProtectionOrder(String string) {
        this.publicFirst = string.equalsIgnoreCase("public");
    }

    protected int getIndex(Object object) {
        Node node = ((SimpleNode)object).jjtGetChild(0);
        if (node instanceof ASTClassBodyDeclaration) {
            node = ((ASTClassBodyDeclaration)node).jjtGetChild(0);
        } else if (node instanceof ASTInterfaceMemberDeclaration) {
            node = ((ASTInterfaceMemberDeclaration)node).jjtGetChild(0);
        }
        int n = 0;
        if (node instanceof ASTFieldDeclaration) {
            n = this.getProtection(((ASTFieldDeclaration)node).getModifiers());
        } else if (node instanceof ASTConstructorDeclaration) {
            n = this.getProtection(((ASTConstructorDeclaration)node).getModifiers());
        } else if (node instanceof ASTMethodDeclaration) {
            n = this.getProtection(((ASTMethodDeclaration)node).getModifiers());
        } else if (node instanceof ASTNestedInterfaceDeclaration) {
            n = this.getProtection(((ASTNestedInterfaceDeclaration)node).getModifiers());
        } else if (node instanceof ASTNestedClassDeclaration) {
            n = this.getProtection(((ASTNestedClassDeclaration)node).getModifiers());
        } else {
            return 100;
        }
        if (this.publicFirst) {
            return n;
        }
        return -n;
    }

    private int getProtection(ModifierHolder modifierHolder) {
        if (modifierHolder.isPrivate()) {
            return 4;
        }
        if (modifierHolder.isProtected()) {
            return 2;
        }
        if (modifierHolder.isPublic()) {
            return 1;
        }
        return 3;
    }
}

