/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.sort;

import java.util.StringTokenizer;
import org.acm.seguin.pretty.sort.AlphabeticalOrder;
import org.acm.seguin.pretty.sort.BeanTogetherOrder;
import org.acm.seguin.pretty.sort.FieldInitializerOrder;
import org.acm.seguin.pretty.sort.FinalOrder;
import org.acm.seguin.pretty.sort.Ordering;
import org.acm.seguin.pretty.sort.ProtectionOrder;
import org.acm.seguin.pretty.sort.SetterGetterOrder;
import org.acm.seguin.pretty.sort.StaticOrder;
import org.acm.seguin.pretty.sort.TypeOrder;
import org.acm.seguin.util.Comparator;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.Settings;

public class MultipleOrdering
implements Comparator {
    private Ordering[] ordering;

    public MultipleOrdering(Settings settings) {
        int n = 0;
        try {
            while (true) {
                settings.getString("sort." + (n + 1));
                ++n;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            this.ordering = new Ordering[n];
            this.load(settings);
            return;
        }
    }

    public MultipleOrdering(String[] stringArray) {
        this.ordering = new Ordering[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.ordering[n] = this.parse(stringArray[n]);
            ++n;
        }
    }

    public int compare(Object object, Object object2) {
        int n = 0;
        while (n < this.ordering.length) {
            int n2 = this.ordering[n].compare(object, object2);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    private void load(Settings settings) {
        int n = 0;
        while (n < this.ordering.length) {
            String string = settings.getString("sort." + (n + 1));
            this.ordering[n] = this.parse(string);
            ++n;
        }
    }

    private Ordering parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
        String string2 = stringTokenizer.nextToken();
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2.equals("Type")) {
            return new TypeOrder(string3);
        }
        if (string2.equals("Class")) {
            return new StaticOrder(string3);
        }
        if (string2.equals("Protection")) {
            return new ProtectionOrder(string3);
        }
        if (string2.equals("Method")) {
            return new SetterGetterOrder(string3);
        }
        if (string2.equals("FieldInitializers")) {
            return new FieldInitializerOrder();
        }
        if (string2.equals("Final")) {
            return new FinalOrder(string3.equalsIgnoreCase("top"));
        }
        if (string2.equals("Alphabetical")) {
            return new AlphabeticalOrder();
        }
        if (string2.equals("Bean")) {
            return new BeanTogetherOrder();
        }
        return null;
    }
}

