/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty.ai;

import java.text.MessageFormat;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclarator;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTResultType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.pretty.DescriptionPadder;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.ai.ParseVariableName;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class MethodAnalyzer {
    private ASTMethodDeclaration node;
    private JavaDocableImpl jdi;
    private ParseVariableName pvn;
    private JavadocTags jt;

    public MethodAnalyzer(ASTMethodDeclaration aSTMethodDeclaration, JavaDocableImpl javaDocableImpl) {
        this.node = aSTMethodDeclaration;
        this.jdi = javaDocableImpl;
        this.pvn = new ParseVariableName();
        this.jt = JavadocTags.get();
    }

    public void finish(String string) {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        this.requireDescription(fileSettings, string);
        String string2 = "return,param,exception,throws";
        try {
            string2 = fileSettings.getString("method.tags");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        if (string2.indexOf("return") >= 0) {
            this.finishReturn(fileSettings);
        }
        if (string2.indexOf("param") >= 0) {
            this.finishParameters(fileSettings);
        }
        if (string2.indexOf("exception") >= 0 || string2.indexOf("throws") >= 0 || string2.indexOf(this.jt.getExceptionTag()) >= 0) {
            this.finishExceptions(fileSettings);
        }
    }

    private boolean isSetter() {
        String string = this.getName();
        return string.length() > 3 && string.startsWith("set") && Character.isUpperCase(string.charAt(3));
    }

    private boolean isGetter() {
        String string = this.getName();
        return string.length() > 3 && string.startsWith("get") && Character.isUpperCase(string.charAt(3)) || string.length() > 2 && string.startsWith("is") && Character.isUpperCase(string.charAt(2));
    }

    private boolean isAdder() {
        String string = this.getName();
        return string.length() > 3 && string.startsWith("add") && Character.isUpperCase(string.charAt(3));
    }

    private boolean isRunMethod() {
        String string = this.getName();
        return string.equals("run");
    }

    private boolean isMainMethod() {
        ASTName aSTName;
        String string = this.getName();
        if (!string.equals("main") || !this.node.isStatic()) {
            return false;
        }
        ASTResultType aSTResultType = (ASTResultType)this.node.jjtGetChild(0);
        if (aSTResultType.hasAnyChildren()) {
            return false;
        }
        ASTMethodDeclarator aSTMethodDeclarator = (ASTMethodDeclarator)this.node.jjtGetChild(1);
        ASTFormalParameters aSTFormalParameters = (ASTFormalParameters)aSTMethodDeclarator.jjtGetChild(0);
        int n = aSTFormalParameters.jjtGetNumChildren();
        if (n != 1) {
            return false;
        }
        ASTFormalParameter aSTFormalParameter = (ASTFormalParameter)aSTFormalParameters.jjtGetChild(0);
        ASTType aSTType = (ASTType)aSTFormalParameter.jjtGetChild(0);
        if (aSTType.getArrayCount() != 1) {
            return false;
        }
        Node node = aSTType.jjtGetChild(0);
        return node instanceof ASTName && ((aSTName = (ASTName)node).getName().equals("String") || aSTName.getName().equals("java.lang.String"));
    }

    private boolean isJUnitSetupMethod() {
        String string = this.getName();
        return string.equals("setUp");
    }

    private boolean isJUnitTestMethod() {
        String string = this.getName();
        return string.startsWith("test");
    }

    private boolean isJUnitTeardownMethod() {
        String string = this.getName();
        return string.equals("tearDown");
    }

    private boolean isJUnitSuiteMethod() {
        String string = this.getName();
        return string.equals("suite");
    }

    private String getName() {
        ASTMethodDeclarator aSTMethodDeclarator = (ASTMethodDeclarator)this.node.jjtGetChild(1);
        return aSTMethodDeclarator.getName();
    }

    private String getAttributeName() {
        String string = this.getName();
        if (!(this.isGetter() || this.isSetter() || this.isAdder())) {
            return "";
        }
        if (string.startsWith("is")) {
            return string.substring(2);
        }
        return string.substring(3);
    }

    private String getParameterDescription(FileSettings fileSettings, String string) {
        String string2 = "";
        string2 = this.isSetter() ? fileSettings.getString("setter.param.descr") : (this.isAdder() ? fileSettings.getString("adder.param.descr") : (this.isMainMethod() ? fileSettings.getString("main.param.descr") : this.jt.getParamDescr()));
        return this.createDescription(string2, this.getAttributeName(), string);
    }

    private String getReturnDescription(FileSettings fileSettings) {
        String string = "";
        string = this.isJUnitSuiteMethod() ? fileSettings.getString("junit.suite.return.descr") : (this.isGetter() ? fileSettings.getString("getter.return.descr") : this.jt.getReturnDescr());
        return this.createDescription(string, this.getAttributeName(), "");
    }

    private void finishReturn(FileSettings fileSettings) {
        ASTResultType aSTResultType = (ASTResultType)this.node.jjtGetChild(0);
        if (aSTResultType.hasAnyChildren() && !this.jdi.contains("@return")) {
            this.jdi.require("@return", this.getReturnDescription(fileSettings));
        }
    }

    private void finishParameters(FileSettings fileSettings) {
        ASTMethodDeclarator aSTMethodDeclarator = (ASTMethodDeclarator)this.node.jjtGetChild(1);
        ASTFormalParameters aSTFormalParameters = (ASTFormalParameters)aSTMethodDeclarator.jjtGetChild(0);
        int n = aSTFormalParameters.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            ASTFormalParameter aSTFormalParameter = (ASTFormalParameter)aSTFormalParameters.jjtGetChild(n2);
            ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTFormalParameter.jjtGetChild(1);
            if (!this.jdi.contains("@param", aSTVariableDeclaratorId.getName())) {
                this.jdi.require("@param", aSTVariableDeclaratorId.getName(), this.getParameterDescription(fileSettings, aSTVariableDeclaratorId.getName()));
            }
            ++n2;
        }
    }

    private void finishExceptions(FileSettings fileSettings) {
        if (this.node.jjtGetNumChildren() > 2 && this.node.jjtGetChild(2) instanceof ASTNameList) {
            String string = this.jt.getExceptionTag();
            ASTNameList aSTNameList = (ASTNameList)this.node.jjtGetChild(2);
            int n = aSTNameList.jjtGetNumChildren();
            int n2 = 0;
            while (n2 < n) {
                ASTName aSTName = (ASTName)aSTNameList.jjtGetChild(n2);
                if (!(this.jdi.contains("@exception", aSTName.getName()) || this.jdi.contains("@throws", aSTName.getName()) || this.jdi.contains(string, aSTName.getName()))) {
                    this.jdi.require(string, aSTName.getName(), this.jt.getExceptionDescr());
                }
                ++n2;
            }
        }
    }

    private String createDescription(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3, this.node.isStatic() ? "class" : "object", this.lowerCaseFirstLetter(string2), this.pvn.parse(string2)};
        String string4 = MessageFormat.format(string, objectArray);
        return string4;
    }

    private void requireDescription(FileSettings fileSettings, String string) {
        String string2 = "";
        string2 = this.isJUnitSetupMethod() ? fileSettings.getString("junit.setUp.descr") : (this.isJUnitTestMethod() ? fileSettings.getString("junit.test.descr") : (this.isJUnitTeardownMethod() ? fileSettings.getString("junit.tearDown.descr") : (this.isJUnitSuiteMethod() ? fileSettings.getString("junit.suite.descr") : (this.isGetter() ? fileSettings.getString("getter.descr") : (this.isSetter() ? fileSettings.getString("setter.descr") : (this.isRunMethod() ? fileSettings.getString("run.descr") : (this.isMainMethod() ? fileSettings.getString("main.descr") : (this.isAdder() ? fileSettings.getString("adder.descr") : fileSettings.getString("method.descr")))))))));
        String string3 = this.createDescription(string2, this.getAttributeName(), string);
        string3 = DescriptionPadder.padBuffer(string3, fileSettings);
        this.jdi.require("", string3);
    }

    private String lowerCaseFirstLetter(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

