/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.pretty.FieldSize;
import org.acm.seguin.pretty.LineQueue;
import org.acm.seguin.pretty.sort.MultipleOrdering;
import org.acm.seguin.pretty.sort.SameOrdering;
import org.acm.seguin.pretty.sort.TopLevelOrdering;
import org.acm.seguin.util.Comparator;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;
import org.acm.seguin.util.Settings;

public class PrintData {
    public static final int BLOCK_STYLE_C = 0;
    public static final int BLOCK_STYLE_PASCAL = 1;
    public static final int BLOCK_STYLE_EMACS = 2;
    public static int EMPTY = 0;
    public static int METHOD = 1;
    public static int FIELD = 2;
    public static int INTERFACE = 3;
    public static int CLASS = 3;
    public static int SINGLE_INDENT = 1;
    public static int DOUBLE_INDENT = 2;
    public static int PARAM_INDENT = 3;
    public static final int JAVADOC_COMMENT = 1;
    public static final int C_STYLE_COMMENT = 2;
    public static final int CATEGORY_COMMENT = 3;
    public static final int SINGLE_LINE_COMMENT = 4;
    public static final int DFS_NEVER = 0;
    public static final int DFS_ALWAYS = 1;
    public static final int DFS_NOT_WITH_JAVADOC = 2;
    public static final int DFS_ALIGN_EQUALS = 3;
    public static final int CSC_LEAVE_UNTOUCHED = 1;
    public static final int CSC_ALIGN_STAR = 0;
    public static final int CSC_ALIGN_BLANK = 2;
    public static final int CSC_MAINTAIN_STAR = 3;
    public int finalLine = -1;
    private int last = EMPTY;
    private int INDENT = 4;
    private char indentChar = (char)32;
    private int codeBlockStyle = 0;
    private int methodBlockStyle = 0;
    private int classBlockStyle = 0;
    private boolean isMethodBrace = false;
    private boolean lineUpParams = true;
    private boolean inParams = false;
    private int lastParamIndent = 0;
    private boolean exprSpace = false;
    private int linesBetween = 2;
    private int javadocMinimum = 40;
    private int javadocMaximum = 80;
    private boolean spaceAfterCast = true;
    private boolean spaceAfterKeyword = true;
    private boolean spaceAfterMethod = false;
    private boolean spaceInsideCast = false;
    private int javadocStars = 2;
    private int originalLine = -1;
    private boolean storeJavadocPrinted = false;
    private boolean skipNameSpacing = false;
    private int cStyleFormatCode = 0;
    private int cStyleIndent = 2;
    private boolean isClassBrace = false;
    private boolean emptyBlockOnSingleLine = false;
    private boolean castSpace = true;
    private boolean documentNestedClasses = true;
    private boolean elseOnNewLine = true;
    private boolean allowSingleLineJavadoc = false;
    private boolean currentIsSingle = false;
    private boolean variablesAlignWithBlock = false;
    private FileSettings bundle;
    private int caseIndent;
    private Vector classNameStack;
    private int dynamicFieldSpace;
    private int fieldNameIndent;
    private int fieldSpaceCode;
    private Vector fieldStack;
    private boolean forceBlock;
    private String[] importSortImportant;
    private int importSortNeighbourhood;
    private int indent = 0;
    private boolean keepAllJavadoc;
    private LineQueue lineQueue;
    private MultipleOrdering morder;
    private int newlineCount;
    private StringBuffer outputBuffer;
    private boolean reformatComments;
    private boolean sortTop;
    private int surpriseType;
    private int tempEqualsLength;
    private boolean localVariableSpaceInsert = false;
    private boolean removeExcessBlocks;
    private int linesAfterPackage = 1;
    private boolean maintainNewlinesAroundImports = true;
    private int linesBeforeClass = 0;
    private boolean indentInitializer = false;
    private boolean bangSpace = false;
    private boolean keepErroneousJavadocTags;
    private boolean spaceAroundOps = true;

    public PrintData() {
        this(System.out);
    }

    public PrintData(OutputStream outputStream) {
        String string;
        String string2;
        this.lineQueue = this.lineQueueFactory(new PrintWriter(new OutputStreamWriter(outputStream)));
        this.outputBuffer = new StringBuffer();
        this.newlineCount = 0;
        this.bundle = FileSettings.getSettings("Refactory", "pretty");
        try {
            this.INDENT = this.bundle.getInteger("indent");
            string2 = this.bundle.getString("indent.char");
            this.indentChar = string2.equalsIgnoreCase("space") ? (char)32 : (string2.equalsIgnoreCase("tab") ? (char)9 : string2.charAt(0));
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        this.codeBlockStyle = this.translateBlockStyle("block.style");
        this.methodBlockStyle = this.translateBlockStyle("method.block.style");
        this.classBlockStyle = this.translateBlockStyle("class.block.style");
        try {
            this.exprSpace = new Boolean(this.bundle.getString("expr.space"));
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.lineUpParams = new Boolean(this.bundle.getString("params.lineup"));
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.linesBetween = Integer.parseInt(this.bundle.getString("lines.between"));
        }
        catch (MissingSettingsException missingSettingsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.javadocMinimum = this.bundle.getInteger("javadoc.wordwrap.min");
            this.javadocMaximum = this.bundle.getInteger("javadoc.wordwrap.max");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.spaceAfterCast = this.bundle.getBoolean("cast.space");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.javadocStars = this.bundle.getInteger("javadoc.star");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.spaceAfterKeyword = this.bundle.getBoolean("keyword.space");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            string2 = this.bundle.getString("variable.spacing");
            this.fieldSpaceCode = string2.equalsIgnoreCase("dynamic") ? 1 : (string2.equalsIgnoreCase("javadoc.dynamic") ? 2 : (string2.equalsIgnoreCase("align.equals") ? 3 : 0));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.fieldSpaceCode = 0;
        }
        this.morder = new MultipleOrdering(this.bundle);
        this.classNameStack = new Vector();
        this.fieldStack = new Vector();
        try {
            string2 = this.bundle.getString("surprise.return");
        }
        catch (MissingSettingsException missingSettingsException) {
            System.out.println("Cannot find surprise.return");
            string2 = "double";
        }
        this.surpriseType = string2.equalsIgnoreCase("single") ? SINGLE_INDENT : (string2.equalsIgnoreCase("param") ? PARAM_INDENT : DOUBLE_INDENT);
        try {
            this.reformatComments = this.bundle.getBoolean("reformat.comments");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.reformatComments = true;
        }
        try {
            this.fieldNameIndent = this.bundle.getInteger("field.name.indent");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.fieldNameIndent = -1;
        }
        try {
            this.keepAllJavadoc = this.bundle.getBoolean("keep.all.javadoc");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.keepAllJavadoc = false;
        }
        try {
            this.forceBlock = this.bundle.getBoolean("force.block");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.forceBlock = true;
        }
        try {
            this.dynamicFieldSpace = this.bundle.getInteger("dynamic.variable.spacing");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.dynamicFieldSpace = 1;
        }
        try {
            string = this.bundle.getString("c.style.format");
            this.cStyleFormatCode = string.equalsIgnoreCase("leave") ? 1 : (string.equalsIgnoreCase("maintain.space.star") ? 3 : (string.equalsIgnoreCase("align.blank") ? 2 : 0));
        }
        catch (MissingSettingsException missingSettingsException) {
            this.cStyleFormatCode = 0;
        }
        try {
            this.cStyleIndent = this.bundle.getInteger("c.style.indent");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.cStyleIndent = 2;
        }
        try {
            this.emptyBlockOnSingleLine = this.bundle.getBoolean("empty.block.single.line");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.emptyBlockOnSingleLine = false;
        }
        try {
            this.castSpace = !this.bundle.getBoolean("cast.force.nospace");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.castSpace = true;
        }
        try {
            this.documentNestedClasses = this.bundle.getBoolean("document.nested.classes");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.documentNestedClasses = true;
        }
        try {
            this.allowSingleLineJavadoc = this.bundle.getBoolean("allow.singleline.javadoc");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.allowSingleLineJavadoc = false;
        }
        try {
            this.variablesAlignWithBlock = this.bundle.getBoolean("variable.align.with.block");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.variablesAlignWithBlock = false;
        }
        try {
            this.elseOnNewLine = this.bundle.getBoolean("else.start.line");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.elseOnNewLine = true;
        }
        try {
            this.caseIndent = this.bundle.getInteger("case.indent");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.caseIndent = this.INDENT;
        }
        try {
            this.sortTop = this.bundle.getBoolean("sort.top");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.sortTop = false;
        }
        try {
            string = this.bundle.getString("import.sort.important");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.endsWith(".")) {
                    string3 = string3 + ".";
                }
                vector.add(string3);
            }
            this.importSortImportant = vector.toArray(new String[vector.size()]);
        }
        catch (MissingSettingsException missingSettingsException) {
            this.importSortImportant = new String[0];
        }
        try {
            this.importSortNeighbourhood = this.bundle.getInteger("import.sort.neighbourhood");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.importSortNeighbourhood = 0;
        }
        try {
            this.localVariableSpaceInsert = this.bundle.getBoolean("insert.space.around.local.variables");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.localVariableSpaceInsert = false;
        }
        try {
            this.removeExcessBlocks = this.bundle.getBoolean("remove.excess.blocks");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.removeExcessBlocks = false;
        }
        try {
            this.linesAfterPackage = this.bundle.getInteger("lines.after.package");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.linesAfterPackage = 0;
        }
        try {
            this.maintainNewlinesAroundImports = this.bundle.getBoolean("maintain.newlines.around.imports");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.maintainNewlinesAroundImports = true;
        }
        try {
            this.linesBeforeClass = this.bundle.getInteger("lines.before.class");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.linesBeforeClass = 0;
        }
        try {
            this.indentInitializer = this.bundle.getBoolean("indent.in.initializer");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.indentInitializer = false;
        }
        try {
            this.bangSpace = this.bundle.getBoolean("bang.space");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.bangSpace = false;
        }
        try {
            this.keepErroneousJavadocTags = this.bundle.getBoolean("keep.erroneous.tags");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.keepErroneousJavadocTags = false;
        }
        try {
            this.spaceAfterMethod = this.bundle.getBoolean("method.space");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.spaceInsideCast = this.bundle.getBoolean("cast.inside.space");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        try {
            this.spaceAroundOps = this.bundle.getBoolean("space.around.ops");
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        this.fieldStack = new Vector();
    }

    public void setAbsoluteCommentSpacing(int n) {
        this.lineQueue.setAbsoluteCommentSpacing(n);
    }

    public void setCStyleFormatCode(int n) {
        this.cStyleFormatCode = n;
    }

    public void setCStyleIndent(int n) {
        this.cStyleIndent = n;
    }

    public void setCaseIndent(int n) {
        this.caseIndent = n;
    }

    public void setCastSpace(boolean bl) {
        this.castSpace = bl;
    }

    public void setClassBlockStyle(int n) {
        this.classBlockStyle = n;
    }

    public void setCodeBlockStyle(int n) {
        this.codeBlockStyle = n;
    }

    public void setCurrentIsSingle(boolean bl) {
        this.currentIsSingle = bl;
    }

    public void setDocumentNestedClasses(boolean bl) {
        this.documentNestedClasses = bl;
    }

    public void setDynamicFieldSpaces(int n) {
        this.dynamicFieldSpace = n;
    }

    public void setDynamicFieldSpacing(int n) {
        this.fieldSpaceCode = n;
    }

    public void setElseOnNewLine(boolean bl) {
        this.elseOnNewLine = bl;
    }

    public void setEmptyBlockOnSingleLine(boolean bl) {
        this.emptyBlockOnSingleLine = bl;
    }

    public void setExpressionSpace(boolean bl) {
        this.exprSpace = bl;
    }

    public void setFinalLine(int n) {
        this.finalLine = n;
    }

    public void setForceBlock(boolean bl) {
        this.forceBlock = bl;
    }

    public void setImportSortImportant(String[] stringArray) {
        this.importSortImportant = stringArray;
    }

    public void setImportSortNeighbourhood(int n) {
        this.importSortNeighbourhood = n;
    }

    public void setIncrementalCommentSpacing(int n) {
        this.lineQueue.setIncrementalCommentSpacing(n);
    }

    public void setMethodBlockStyle(int n) {
        this.methodBlockStyle = n;
    }

    public void setMultipleOrdering(MultipleOrdering multipleOrdering) {
        if (multipleOrdering != null) {
            this.morder = multipleOrdering;
        }
    }

    public void setOriginalLine(int n) {
        this.originalLine = n;
    }

    public void setOutput(PrintWriter printWriter) {
        if (printWriter != null) {
            this.lineQueue = this.lineQueueFactory(printWriter);
        }
    }

    public void setOwnline(boolean bl) {
        this.lineQueue.setOwnline(bl);
    }

    public void setOwnlineCode(boolean bl) {
        this.lineQueue.setOwnlineCode(bl);
    }

    public void setParamIndent() {
        if (this.inParams && this.lastParamIndent == 0) {
            this.lastParamIndent = this.getLineLength();
        }
    }

    public void setReformatComments(boolean bl) {
        this.reformatComments = bl;
    }

    public void setSharedIncr(boolean bl) {
        this.lineQueue.setSharedIncremental(bl);
    }

    public void setSingleLineJavadoc(boolean bl) {
        this.allowSingleLineJavadoc = bl;
    }

    public void setSortTop(boolean bl) {
        this.sortTop = bl;
    }

    public void setState(int n) {
        this.last = n;
    }

    public void setVariablesAlignWithBlock(boolean bl) {
        this.variablesAlignWithBlock = bl;
    }

    public int getCStyleFormatCode() {
        return this.cStyleFormatCode;
    }

    public int getCStyleIndent() {
        return this.cStyleIndent;
    }

    public String getCurrentClassName() {
        return (String)this.classNameStack.elementAt(this.classNameStack.size() - 1);
    }

    public int getDynamicFieldSpaces() {
        return this.dynamicFieldSpace;
    }

    public boolean isEmptyBlockOnSingleLine() {
        return this.emptyBlockOnSingleLine;
    }

    public int getFieldNameIndent() {
        return this.fieldNameIndent;
    }

    public int getFieldSpaceCode() {
        return this.fieldSpaceCode;
    }

    public int getFinalLine() {
        return this.finalLine;
    }

    public String[] getImportSortImportant() {
        return this.importSortImportant;
    }

    public int getImportSortNeighbourhood() {
        return this.importSortNeighbourhood;
    }

    public String getIndentString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.indent) {
            stringBuffer.append(this.indentChar);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getJavadocIndent() {
        try {
            return this.bundle.getInteger("javadoc.indent");
        }
        catch (MissingSettingsException missingSettingsException) {
            return 2;
        }
    }

    public int getJavadocStarCount() {
        return this.javadocStars;
    }

    public int getJavadocWordWrapMaximum() {
        return this.javadocMaximum;
    }

    public int getJavadocWordWrapMinimum() {
        return this.javadocMinimum;
    }

    public int getLineLength() {
        return this.outputBuffer.length();
    }

    public MultipleOrdering getOrder() {
        return this.morder;
    }

    public int getOriginalLine() {
        return this.originalLine;
    }

    public int getParamIndent() {
        if (this.inParams) {
            return this.lastParamIndent;
        }
        return 0;
    }

    public Settings getSettings() {
        return this.bundle;
    }

    public int getState() {
        return this.last;
    }

    public int getSurpriseReturn() {
        return this.surpriseType;
    }

    public Comparator getTopOrder(ASTCompilationUnit aSTCompilationUnit) {
        try {
            if (this.sortTop) {
                return new TopLevelOrdering(aSTCompilationUnit, this);
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return new SameOrdering();
    }

    public boolean isAllJavadocKept() {
        return this.keepAllJavadoc;
    }

    public boolean isAllowSingleLineJavadoc() {
        return this.allowSingleLineJavadoc;
    }

    public boolean isBufferEmpty() {
        return this.outputBuffer.toString().trim().length() == 0;
    }

    public boolean isCastSpace() {
        return this.castSpace;
    }

    public boolean isCatchOnNewLine() {
        try {
            return this.bundle.getBoolean("catch.start.line");
        }
        catch (MissingSettingsException missingSettingsException) {
            return true;
        }
    }

    public boolean isCurrentSingle() {
        return this.currentIsSingle;
    }

    public boolean isDynamicFieldSpacing(boolean bl) {
        if (this.skipNameSpacing) {
            return false;
        }
        return !bl && this.fieldSpaceCode == 2 || this.fieldSpaceCode == 1;
    }

    public boolean isElseOnNewLine() {
        return this.elseOnNewLine;
    }

    public boolean isFieldNameIndented() {
        return this.fieldNameIndent > 0;
    }

    public boolean isForcingBlock() {
        return this.forceBlock;
    }

    public boolean isJavadocLinedUp() {
        try {
            return this.bundle.getBoolean("javadoc.id.lineup");
        }
        catch (MissingSettingsException missingSettingsException) {
            return true;
        }
    }

    public boolean isLineIndented() {
        return this.isBufferEmpty() && (this.outputBuffer.toString().length() > 0 || this.indent == 0);
    }

    public boolean isNestedClassDocumented() {
        return this.documentNestedClasses;
    }

    public boolean isReformatComments() {
        return this.reformatComments;
    }

    public boolean isSpaceAfterCast() {
        return this.spaceAfterCast;
    }

    public boolean isSpaceAfterKeyword() {
        return this.spaceAfterKeyword;
    }

    public boolean isSpaceBeforeAt() {
        try {
            return this.bundle.getBoolean("space.before.javadoc");
        }
        catch (MissingSettingsException missingSettingsException) {
            return false;
        }
    }

    public boolean isThrowsOnNewline() {
        try {
            return this.bundle.getBoolean("throws.newline");
        }
        catch (MissingSettingsException missingSettingsException) {
            return false;
        }
    }

    public boolean isVariablesAlignWithBlock() {
        return this.variablesAlignWithBlock;
    }

    public void appendComment(String string, int n) {
        if (n == 3) {
            this.lineQueue.appendCategoryComment(string, this.outputBuffer.toString());
            ++this.newlineCount;
        } else if (n == 4) {
            this.lineQueue.appendSingleLineComment(string, this.outputBuffer.toString());
            --this.newlineCount;
        } else {
            this.append(string);
        }
    }

    public void appendConstant(String string) {
        this.outputBuffer.append(string);
    }

    public void appendKeyword(String string) {
        this.append(string);
    }

    public void appendText(String string) {
        this.append(string);
    }

    public void backspace() {
        this.outputBuffer.setLength(this.outputBuffer.length() - 1);
    }

    public void beginBlock() {
        this.beginBlock(true, true);
    }

    public void beginBlock(boolean bl) {
        this.beginBlock(bl, true);
    }

    public void beginBlock(boolean bl, boolean bl2) {
        int n = this.getCurrentBlockStyle();
        if (n == 0) {
            if (bl) {
                this.space();
            }
            this.append("{");
        } else {
            if (n == 2) {
                this.incrIndent();
            }
            this.indent();
            this.append("{");
        }
        this.isMethodBrace = false;
        this.isClassBrace = false;
        if (bl2) {
            this.newline();
        }
        this.incrIndent();
    }

    public void beginClass() {
        if (this.last != EMPTY) {
            int n = 0;
            while (n < this.linesBetween) {
                this.newline();
                ++n;
            }
        }
        this.last = EMPTY;
    }

    public void beginExpression(boolean bl) {
        if (!bl || !this.exprSpace) {
            this.append("(");
        } else {
            this.append("( ");
        }
    }

    public void beginField() {
        if (this.last != EMPTY && this.last != FIELD) {
            int n = 0;
            while (n < this.linesBetween) {
                this.newline();
                ++n;
            }
        }
    }

    public void beginInterface() {
        if (this.last != EMPTY) {
            int n = 0;
            while (n < this.linesBetween) {
                this.newline();
                ++n;
            }
        }
        this.last = EMPTY;
    }

    public void beginMethod() {
        if (this.last != EMPTY) {
            int n = 0;
            while (n < this.linesBetween) {
                this.newline();
                ++n;
            }
        }
    }

    public void classBrace() {
        this.isClassBrace = true;
    }

    public void close() {
        this.flush();
        this.lineQueue.getOutput().close();
    }

    public boolean consumeNewline() {
        this.lineQueue.flushFirstLine();
        if (!this.isBufferEmpty()) {
            this.newlineCount = 0;
        }
        if (this.newlineCount > 0) {
            --this.newlineCount;
            return true;
        }
        this.newline();
        this.lineQueue.flush();
        return false;
    }

    public void decrCaseIndent() {
        this.incrIndent(-this.caseIndent);
    }

    public void decrIndent() {
        this.incrIndent(-this.INDENT);
    }

    public void endBlock(boolean bl, boolean bl2) {
        this.decrIndent();
        if (bl2 || this.outputBuffer.length() == 0) {
            this.indent();
        }
        if (this.getCurrentBlockStyle() == 2) {
            this.decrIndent();
        }
        this.append("}");
        if (bl) {
            this.newline();
        }
        this.isMethodBrace = false;
        this.isClassBrace = false;
    }

    public void endBlock() {
        this.endBlock(true, true);
    }

    public void endClass() {
        this.last = CLASS;
    }

    public void endExpression(boolean bl) {
        if (!bl || !this.exprSpace) {
            this.append(")");
        } else {
            this.append(" )");
        }
    }

    public void endField() {
        this.last = FIELD;
    }

    public void endInterface() {
        this.last = INTERFACE;
    }

    public void endMethod() {
        this.last = METHOD;
    }

    public void enterMethodDecl() {
        this.inParams = true;
        this.lastParamIndent = 0;
    }

    public void exitMethodDecl() {
        this.inParams = false;
        this.lastParamIndent = 0;
    }

    public void flush() {
        this.lineQueue.flush();
    }

    public void incrCaseIndent() {
        this.incrIndent(this.caseIndent);
    }

    public void incrIndent() {
        this.incrIndent(this.INDENT);
    }

    public void indent() {
        if (!this.isBufferEmpty()) {
            this.newline();
        }
        this.outputBuffer.setLength(0);
        this.append(this.getIndentString());
    }

    public void indentParam() {
        if (this.surpriseType == PARAM_INDENT && this.lastParamIndent > 0) {
            this.indent();
            int n = 0;
            while (n < this.lastParamIndent - this.indent) {
                this.append(" ");
                ++n;
            }
        } else {
            this.incrIndent();
            this.indent();
            this.decrIndent();
        }
    }

    public void methodBrace() {
        this.isMethodBrace = true;
    }

    public void newline() {
        String string = "";
        if (this.isBufferEmpty()) {
            this.outputBuffer.setLength(0);
            this.lineQueue.println("");
            ++this.newlineCount;
        } else {
            string = this.outputBuffer.toString();
            this.lineQueue.println(this.outputBuffer.toString());
            this.outputBuffer.setLength(0);
            this.newlineCount = 1;
        }
    }

    public void popCurrentClassName() {
        this.classNameStack.removeElementAt(this.classNameStack.size() - 1);
    }

    public void popFieldSize() {
        this.fieldStack.removeElementAt(this.fieldStack.size() - 1);
    }

    public void pushCurrentClassName(String string) {
        this.classNameStack.addElement(string);
    }

    public void pushFieldSize(FieldSize fieldSize) {
        this.fieldStack.addElement(fieldSize);
    }

    public void reset() {
        this.outputBuffer.setLength(0);
    }

    public void saveCurrentLine() {
        this.setFinalLine(this.lineQueue.getCurrentLine());
    }

    public void space() {
        this.append(" ");
    }

    public FieldSize topFieldSize() {
        return (FieldSize)this.fieldStack.elementAt(this.fieldStack.size() - 1);
    }

    protected void incrIndent(int n) {
        this.indent += n;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    protected LineQueue lineQueueFactory(PrintWriter printWriter) {
        return new LineQueue(printWriter);
    }

    void setAllJavadocKept(boolean bl) {
        this.keepAllJavadoc = bl;
    }

    void setSkipNameSpacing(boolean bl) {
        this.skipNameSpacing = bl;
    }

    void setStoreJavadocPrinted(boolean bl) {
        this.storeJavadocPrinted = bl;
    }

    void setTempEqualsLength(int n) {
        this.tempEqualsLength = n;
    }

    boolean getSkipNameSpacing() {
        return this.skipNameSpacing;
    }

    int getTempEqualsLength() {
        return this.tempEqualsLength;
    }

    boolean isStoreJavadocPrinted() {
        return this.storeJavadocPrinted;
    }

    private int getCurrentBlockStyle() {
        if (this.isClassBrace) {
            return this.classBlockStyle;
        }
        if (this.isMethodBrace) {
            return this.methodBlockStyle;
        }
        return this.codeBlockStyle;
    }

    private void append(String string) {
        this.outputBuffer.append(string);
    }

    private int translateBlockStyle(String string) {
        try {
            String string2 = this.bundle.getString(string);
            if (string2.equalsIgnoreCase("PASCAL")) {
                return 1;
            }
            if (string2.equalsIgnoreCase("EMACS")) {
                return 2;
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
        return 0;
    }

    public void setInsertSpaceLocalVariables(boolean bl) {
        this.localVariableSpaceInsert = bl;
    }

    public boolean isInsertSpaceLocalVariables() {
        return this.localVariableSpaceInsert;
    }

    public void setRemoveExcessBlocks(boolean bl) {
        this.removeExcessBlocks = bl;
    }

    public boolean isRemoveExcessBlocks() {
        return this.removeExcessBlocks;
    }

    public void setLinesAfterPackage(int n) {
        this.linesAfterPackage = n;
    }

    public int getLinesAfterPackage() {
        return this.linesAfterPackage;
    }

    public void setMaintainNewlinesAroundImports(boolean bl) {
        this.maintainNewlinesAroundImports = bl;
    }

    public boolean isMaintainNewlinesAroundImports() {
        return this.maintainNewlinesAroundImports;
    }

    public void setLinesBeforeClass(int n) {
        this.linesBeforeClass = n;
    }

    public int getLinesBeforeClass() {
        return this.linesBeforeClass;
    }

    public void setIndentInInitializer(boolean bl) {
        this.indentInitializer = bl;
    }

    public boolean isIndentInInitailzer() {
        return this.indentInitializer;
    }

    public void setBangSpace(boolean bl) {
        this.bangSpace = bl;
    }

    public boolean isBangSpace() {
        return this.bangSpace;
    }

    public boolean isKeepErroneousJavadocTags() {
        return this.keepErroneousJavadocTags;
    }

    public void setKeepErroneousJavadocTags(boolean bl) {
        this.keepErroneousJavadocTags = bl;
    }

    public boolean isSpaceInsideCast() {
        return this.spaceInsideCast;
    }

    public boolean isSpaceAfterMethod() {
        return this.spaceAfterMethod;
    }

    public void setSpaceInsideCast(boolean bl) {
        this.spaceInsideCast = bl;
    }

    public void setSpaceAfterMethod(boolean bl) {
        this.spaceAfterMethod = bl;
    }

    public void setSpaceAroundOperators(boolean bl) {
        this.spaceAroundOps = bl;
    }

    public boolean isSpaceAroundOperators() {
        return this.spaceAroundOps;
    }
}

