/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.acm.seguin.awt.Question;
import org.acm.seguin.io.InplaceOutputStream;
import org.acm.seguin.parser.ast.ASTCompilationUnit;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.PrettyPrintVisitor;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.util.FileSettings;

public class PrettyPrintFile {
    private ParserFactory factory;
    private boolean ask = true;

    public void setAsk(boolean bl) {
        this.ask = bl;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.factory = parserFactory;
    }

    public boolean isApplicable(File file) {
        if (!file.canWrite()) {
            return false;
        }
        boolean bl = true;
        if (this.ask) {
            bl = Question.isYes("Pretty Printer", "Do you want to pretty print the file\n" + file.getPath() + "?");
        }
        if (bl) {
            this.setParserFactory(new FileParserFactory(file));
        }
        return bl;
    }

    public ParserFactory getParserFactory() {
        return this.factory;
    }

    public void apply(File file) {
        SimpleNode simpleNode = this.factory.getAbstractSyntaxTree(true);
        this.apply(file, simpleNode);
    }

    public void apply(File file, SimpleNode simpleNode) {
        if (simpleNode != null) {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
            fileSettings.setReloadNow(true);
            PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
            PrintData printData = this.getPrintData(file);
            if (simpleNode instanceof ASTCompilationUnit) {
                prettyPrintVisitor.visit((ASTCompilationUnit)simpleNode, (Object)printData);
            } else {
                prettyPrintVisitor.visit(simpleNode, (Object)printData);
            }
            printData.close();
        }
    }

    protected OutputStream getOutputStream(File file) {
        OutputStream outputStream = null;
        try {
            outputStream = new InplaceOutputStream(file);
        }
        catch (IOException iOException) {
            outputStream = System.out;
        }
        return outputStream;
    }

    protected PrintData getPrintData(File file) {
        JavadocTags.get().reload();
        return new PrintData(this.getOutputStream(file));
    }
}

