/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.Serializable;

public class ModifierHolder
implements Serializable {
    private int modifiers = 0;
    protected static int ABSTRACT = 1;
    protected static int EXPLICIT = 2;
    protected static int FINAL = 4;
    protected static int INTERFACE = 8;
    protected static int NATIVE = 16;
    protected static int PRIVATE = 32;
    protected static int PROTECTED = 64;
    protected static int PUBLIC = 128;
    protected static int STATIC = 256;
    protected static int STRICT = 512;
    protected static int SYNCHRONIZED = 1024;
    protected static int TRANSIENT = 2048;
    protected static int VOLATILE = 4096;
    protected static int STRICTFP = 8192;
    protected static String[] names = new String[]{"abstract", "explicit", "final", "interface", "native", "private", "protected", "public", "static", "strict", "strictfp", "synchronized", "transient", "volatile"};

    public void setPrivate(boolean bl) {
        this.setCode(bl, PRIVATE);
    }

    public void setProtected(boolean bl) {
        this.setCode(bl, PROTECTED);
    }

    public void setPublic(boolean bl) {
        this.setCode(bl, PUBLIC);
    }

    public void setAbstract(boolean bl) {
        this.setCode(bl, ABSTRACT);
    }

    public void setSynchronized(boolean bl) {
        this.setCode(bl, SYNCHRONIZED);
    }

    public void setStatic(boolean bl) {
        this.setCode(bl, STATIC);
    }

    public boolean isAbstract() {
        return (this.modifiers & ABSTRACT) != 0;
    }

    public boolean isExplicit() {
        return (this.modifiers & EXPLICIT) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & FINAL) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & INTERFACE) != 0;
    }

    public boolean isNative() {
        return (this.modifiers & NATIVE) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & PRIVATE) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & PROTECTED) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & PUBLIC) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers & STATIC) != 0;
    }

    public boolean isStrict() {
        return (this.modifiers & STRICT) != 0;
    }

    public boolean isStrictFP() {
        return (this.modifiers & STRICTFP) != 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & SYNCHRONIZED) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & TRANSIENT) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & VOLATILE) != 0;
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public void add(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equalsIgnoreCase(names[0])) {
            this.modifiers |= ABSTRACT;
        } else if (string.equalsIgnoreCase(names[1])) {
            this.modifiers |= EXPLICIT;
        } else if (string.equalsIgnoreCase(names[2])) {
            this.modifiers |= FINAL;
        } else if (string.equalsIgnoreCase(names[3])) {
            this.modifiers |= INTERFACE;
        } else if (string.equalsIgnoreCase(names[4])) {
            this.modifiers |= NATIVE;
        } else if (string.equalsIgnoreCase(names[5])) {
            this.modifiers |= PRIVATE;
        } else if (string.equalsIgnoreCase(names[6])) {
            this.modifiers |= PROTECTED;
        } else if (string.equalsIgnoreCase(names[7])) {
            this.modifiers |= PUBLIC;
        } else if (string.equalsIgnoreCase(names[8])) {
            this.modifiers |= STATIC;
        } else if (string.equalsIgnoreCase(names[9])) {
            this.modifiers |= STRICT;
        } else if (string.equalsIgnoreCase(names[10])) {
            this.modifiers |= STRICTFP;
        } else if (string.equalsIgnoreCase(names[11])) {
            this.modifiers |= SYNCHRONIZED;
        } else if (string.equalsIgnoreCase(names[12])) {
            this.modifiers |= TRANSIENT;
        } else if (string.equalsIgnoreCase(names[13])) {
            this.modifiers |= VOLATILE;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPrivate()) {
            stringBuffer.append(names[5]);
            stringBuffer.append(" ");
        }
        if (this.isProtected()) {
            stringBuffer.append(names[6]);
            stringBuffer.append(" ");
        }
        if (this.isPublic()) {
            stringBuffer.append(names[7]);
            stringBuffer.append(" ");
        }
        if (this.isAbstract()) {
            stringBuffer.append(names[0]);
            stringBuffer.append(" ");
        }
        if (this.isExplicit()) {
            stringBuffer.append(names[1]);
            stringBuffer.append(" ");
        }
        if (this.isFinal()) {
            stringBuffer.append(names[2]);
            stringBuffer.append(" ");
        }
        if (this.isInterface()) {
            stringBuffer.append(names[3]);
            stringBuffer.append(" ");
        }
        if (this.isNative()) {
            stringBuffer.append(names[4]);
            stringBuffer.append(" ");
        }
        if (this.isStatic()) {
            stringBuffer.append(names[8]);
            stringBuffer.append(" ");
        }
        if (this.isStrict()) {
            stringBuffer.append(names[9]);
            stringBuffer.append(" ");
        }
        if (this.isStrictFP()) {
            stringBuffer.append(names[10]);
            stringBuffer.append(" ");
        }
        if (this.isSynchronized()) {
            stringBuffer.append(names[11]);
            stringBuffer.append(" ");
        }
        if (this.isTransient()) {
            stringBuffer.append(names[12]);
            stringBuffer.append(" ");
        }
        if (this.isVolatile()) {
            stringBuffer.append(names[13]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void copy(ModifierHolder modifierHolder) {
        this.modifiers = modifierHolder.modifiers;
    }

    public boolean equals(Object object) {
        if (object instanceof ModifierHolder) {
            ModifierHolder modifierHolder = (ModifierHolder)object;
            return modifierHolder.modifiers == this.modifiers;
        }
        return false;
    }

    public int hashCode() {
        return this.modifiers;
    }

    protected void setCode(boolean bl, int n) {
        this.modifiers = bl ? (this.modifiers |= n) : (this.modifiers &= ~n);
    }
}

