/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.io.PrintWriter;
import java.util.Vector;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class LineQueue {
    protected int lineNumber;
    private Vector list;
    private PrintWriter output;
    private int absoluteSpace;
    private int incrementalSpace;
    private boolean ownline;
    private boolean sharedIncremental;
    private boolean ownlineCode;
    private StringBuffer buffer;
    private String endOfLine;

    public LineQueue(PrintWriter printWriter) {
        String string;
        this.output = printWriter;
        this.list = new Vector();
        this.buffer = new StringBuffer();
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        try {
            this.absoluteSpace = fileSettings.getInteger("singleline.comment.absoluteindent");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.absoluteSpace = 0;
        }
        try {
            this.incrementalSpace = fileSettings.getInteger("singleline.comment.incrementalindent");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.incrementalSpace = 0;
        }
        try {
            this.ownline = fileSettings.getBoolean("singleline.comment.ownline");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.ownline = true;
        }
        try {
            string = fileSettings.getString("singleline.comment.indentstyle.shared");
            this.sharedIncremental = string.equalsIgnoreCase("incremental");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.sharedIncremental = true;
        }
        try {
            string = fileSettings.getString("singleline.comment.indentstyle.ownline");
            this.ownlineCode = string.equalsIgnoreCase("code");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.ownlineCode = true;
        }
        try {
            string = fileSettings.getString("end.line");
            this.endOfLine = string.equalsIgnoreCase("CRNL") ? "\r\n" : (string.equalsIgnoreCase("CR") ? "\r" : "\n");
        }
        catch (MissingSettingsException missingSettingsException) {
            this.endOfLine = "\n";
        }
        this.lineNumber = 1;
    }

    public void setAbsoluteCommentSpacing(int n) {
        this.absoluteSpace = n;
    }

    public void setIncrementalCommentSpacing(int n) {
        this.incrementalSpace = n;
    }

    public void setOwnline(boolean bl) {
        this.ownline = bl;
    }

    public void setSharedIncremental(boolean bl) {
        this.sharedIncremental = bl;
    }

    public void setOwnlineCode(boolean bl) {
        this.ownlineCode = bl;
    }

    public int getCurrentLine() {
        return this.lineNumber;
    }

    public void println(String string) {
        if (string.length() > 0) {
            this.flush();
        }
        this.list.addElement(string);
    }

    public void appendSingleLineComment(String string, String string2) {
        if (this.list.size() > 0) {
            if (this.ownline) {
                this.list.insertElementAt(this.makeLine(string2, string), 1);
                this.flushFirstLine();
            } else {
                this.updateLine(string, string2);
            }
        } else {
            this.println(this.makeLine(string2, string));
        }
        this.flushFirstLine();
    }

    public void appendCategoryComment(String string, String string2) {
        if (this.list.size() > 0) {
            String string3 = (String)this.list.elementAt(0);
            if (string3.length() > 0) {
                this.list.insertElementAt(string2 + string, 1);
                this.flushFirstLine();
            } else {
                this.list.insertElementAt(string2 + string, 0);
            }
        } else {
            this.println(string2 + string);
        }
        this.flushFirstLine();
    }

    public void flushFirstLine() {
        if (this.list.size() > 0) {
            this.writeln((String)this.list.elementAt(0));
            this.list.removeElementAt(0);
        }
    }

    public void flush() {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            this.writeln((String)this.list.elementAt(n2));
            ++n2;
        }
        this.list.removeAllElements();
        this.output.flush();
    }

    protected PrintWriter getOutput() {
        return this.output;
    }

    protected void writeln(String string) {
        this.buffer.setLength(0);
        this.buffer.append(string);
        int n = string.length();
        while (n > 0 && Character.isWhitespace(this.buffer.charAt(n - 1))) {
            this.buffer.setLength(--n);
        }
        this.output.print(this.buffer.toString());
        this.output.print(this.endOfLine);
        ++this.lineNumber;
    }

    private void updateLine(String string, String string2) {
        String string3 = (String)this.list.elementAt(0);
        if (string3.length() == 0) {
            this.list.setElementAt(this.makeLine(string2, string), 0);
            return;
        }
        if (!this.sharedIncremental) {
            this.list.setElementAt(this.makeLine(string3, string), 0);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = 0;
        while (n < this.incrementalSpace) {
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(string);
        this.list.setElementAt(stringBuffer.toString(), 0);
    }

    private String makeLine(String string, String string2) {
        boolean bl;
        if (string.length() == 0) {
            return string2;
        }
        String string3 = string.trim();
        boolean bl2 = string3 == null || string3.length() == 0;
        boolean bl3 = bl = bl2 && !this.ownlineCode || !bl2 && !this.sharedIncremental;
        if (bl) {
            StringBuffer stringBuffer = !bl2 ? new StringBuffer(string) : new StringBuffer();
            while (stringBuffer.length() < this.absoluteSpace) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string + string2;
    }
}

