/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;

public class JavadocTokenizer {
    private String value;
    private int index;
    private StringBuffer buffer;
    private int last;
    public static final int SPACE = 0;
    public static final int NEWLINE = 1;
    public static final int WORD = 2;

    public JavadocTokenizer(String string) {
        this.value = string;
        this.index = 0;
        this.buffer = new StringBuffer();
        this.last = this.value.length();
    }

    public boolean hasNext() {
        return this.index < this.last;
    }

    public Token next() {
        Token token = new Token();
        if (this.index == this.last) {
            token.kind = 0;
            token.image = " ";
            return token;
        }
        this.buffer.setLength(0);
        if (this.index == 0 && this.value.charAt(this.index) == '*' || this.index == 0 && this.value.charAt(this.index) == '/' || this.value.charAt(this.index) == '\r' || this.value.charAt(this.index) == '\n') {
            if (this.value.charAt(this.index) == '/') {
                ++this.index;
            }
            this.loadNewline();
            token.kind = 1;
            token.image = this.buffer.toString();
        } else if (Character.isWhitespace(this.value.charAt(this.index))) {
            this.loadSpace();
            token.kind = 0;
            token.image = this.buffer.toString();
        } else {
            this.loadWord();
            token.kind = 2;
            token.image = this.checkEnd(this.buffer.toString());
        }
        return token;
    }

    private void loadNewline() {
        while (this.index < this.last && Character.isWhitespace(this.value.charAt(this.index))) {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
        while (this.index < this.last && this.value.charAt(this.index) == '*') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
        if (this.index < this.last && this.value.charAt(this.index) == '/') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
    }

    private void loadSpace() {
        while (this.index < this.last && Character.isWhitespace(this.value.charAt(this.index)) && this.value.charAt(this.index) != '\n' && this.value.charAt(this.index) != '\r') {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
        }
    }

    private void loadWord() {
        int n = this.index;
        while (!(this.index >= this.last || Character.isWhitespace(this.value.charAt(this.index)) || this.value.charAt(this.index) == '<' && this.index != n)) {
            this.buffer.append(this.value.charAt(this.index));
            ++this.index;
            if (this.value.charAt(this.index - 1) != '>') continue;
            return;
        }
    }

    private String checkEnd(String string) {
        if (string.endsWith("*/")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static boolean hasContent(String string) {
        char c;
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (string.charAt(0) == '/') {
            ++n2;
        }
        int n3 = n - 1;
        int n4 = n2;
        while (n4 < n3) {
            c = string.charAt(n4);
            if (!Character.isWhitespace(c) && c != '*') {
                return true;
            }
            ++n4;
        }
        c = string.charAt(n3);
        return !Character.isWhitespace(c) && c != '*' && c != '/';
    }
}

