/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.acm.seguin.parser.io.CharStream;

public final class UCode_CharStream
extends CharStream {
    private static char[] nextCharBuf;
    private static int nextCharInd;

    public UCode_CharStream(Reader reader, int n, int n2, int n3) {
        if (CharStream.inputStream != null) {
            throw new Error("\n   ERROR: Second call to the constructor of a static UCode_CharStream.  You must\n       either use ReInit() or set the JavaCC option STATIC to false\n       during the generation of this class.");
        }
        CharStream.inputStream = reader;
        CharStream.line = n;
        CharStream.column = n2 - 1;
        CharStream.available = CharStream.bufsize = n3;
        CharStream.buffer = new char[n3];
        nextCharBuf = new char[n3];
        CharStream.bufline = new int[n3];
        CharStream.bufcolumn = new int[n3];
    }

    public UCode_CharStream(Reader reader, int n, int n2) {
        this(reader, n, n2, 4096);
    }

    public UCode_CharStream(InputStream inputStream, int n, int n2, int n3) {
        this(new InputStreamReader(inputStream), n, n2, 4096);
    }

    public UCode_CharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public static void ReInit(Reader reader, int n, int n2, int n3) {
        CharStream.inputStream = reader;
        CharStream.line = n;
        CharStream.column = n2 - 1;
        if (CharStream.buffer == null || n3 != CharStream.buffer.length) {
            CharStream.available = CharStream.bufsize = n3;
            CharStream.buffer = new char[n3];
            nextCharBuf = new char[n3];
            CharStream.bufline = new int[n3];
            CharStream.bufcolumn = new int[n3];
        }
    }

    public static void ReInit(Reader reader, int n, int n2) {
        UCode_CharStream.ReInit(reader, n, n2, 4096);
    }

    public static void ReInit(InputStream inputStream, int n, int n2, int n3) {
        UCode_CharStream.ReInit(new InputStreamReader(inputStream), n, n2, 4096);
    }

    public static void ReInit(InputStream inputStream, int n, int n2) {
        UCode_CharStream.ReInit(inputStream, n, n2, 4096);
    }

    public static final int getColumn() {
        return CharStream.bufcolumn[CharStream.bufpos];
    }

    public static final int getLine() {
        return CharStream.bufline[CharStream.bufpos];
    }

    public static final int getEndColumn() {
        return CharStream.bufcolumn[CharStream.bufpos];
    }

    public static final int getEndLine() {
        return CharStream.bufline[CharStream.bufpos];
    }

    public static final int getBeginColumn() {
        return CharStream.bufcolumn[CharStream.tokenBegin];
    }

    public static final int getBeginLine() {
        return CharStream.bufline[CharStream.tokenBegin];
    }

    public static final String GetImage() {
        if (CharStream.bufpos >= CharStream.tokenBegin) {
            return new String(CharStream.buffer, CharStream.tokenBegin, CharStream.bufpos - CharStream.tokenBegin + 1);
        }
        return new String(CharStream.buffer, CharStream.tokenBegin, CharStream.bufsize - CharStream.tokenBegin) + new String(CharStream.buffer, 0, CharStream.bufpos + 1);
    }

    public static final char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (CharStream.bufpos + 1 >= n) {
            System.arraycopy(CharStream.buffer, CharStream.bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(CharStream.buffer, CharStream.bufsize - (n - CharStream.bufpos - 1), cArray, 0, n - CharStream.bufpos - 1);
            System.arraycopy(CharStream.buffer, 0, cArray, n - CharStream.bufpos - 1, CharStream.bufpos + 1);
        }
        return cArray;
    }

    public static char BeginToken() throws IOException {
        CharStream.tokenBegin = -1;
        char c = UCode_CharStream.readChar();
        CharStream.tokenBegin = CharStream.bufpos;
        return c;
    }

    public static final char readChar() throws IOException {
        if (CharStream.inBuf > 0) {
            --CharStream.inBuf;
            return CharStream.buffer[CharStream.bufpos == CharStream.bufsize - 1 ? (CharStream.bufpos = 0) : (CharStream.bufpos = CharStream.bufpos + 1)];
        }
        char c = UCode_CharStream.ReadChar();
        UCode_CharStream.UpdateLineColumn(c);
        if (++CharStream.bufpos == CharStream.available) {
            if (CharStream.available == CharStream.bufsize) {
                if (CharStream.tokenBegin > 2048) {
                    CharStream.bufpos = 0;
                    CharStream.available = CharStream.tokenBegin;
                } else if (CharStream.tokenBegin < 0) {
                    CharStream.bufpos = 0;
                } else {
                    UCode_CharStream.ExpandBuff(false);
                }
            } else if (CharStream.available > CharStream.tokenBegin) {
                CharStream.available = CharStream.bufsize;
            } else if (CharStream.tokenBegin - CharStream.available < 2048) {
                UCode_CharStream.ExpandBuff(true);
            } else {
                CharStream.available = CharStream.tokenBegin;
            }
        }
        CharStream.buffer[CharStream.bufpos] = c;
        return CharStream.buffer[CharStream.bufpos];
    }

    public static final void backup(int n) {
        CharStream.inBuf += n;
        if ((CharStream.bufpos -= n) < 0) {
            CharStream.bufpos += CharStream.bufsize;
        }
    }

    public static void Done() {
        nextCharBuf = null;
        CharStream.buffer = null;
        CharStream.bufline = null;
        CharStream.bufcolumn = null;
    }

    public static void adjustBeginLineColumn(int n, int n2) {
        int n3 = CharStream.tokenBegin;
        int n4 = CharStream.bufpos >= CharStream.tokenBegin ? CharStream.bufpos - CharStream.tokenBegin + CharStream.inBuf + 1 : CharStream.bufsize - CharStream.tokenBegin + CharStream.bufpos + 1 + CharStream.inBuf;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n5 < n4 && CharStream.bufline[n6 = n3 % CharStream.bufsize] == CharStream.bufline[n7 = ++n3 % CharStream.bufsize]) {
            CharStream.bufline[n6] = n;
            n8 = n9 + CharStream.bufcolumn[n7] - CharStream.bufcolumn[n6];
            CharStream.bufcolumn[n6] = n2 + n9;
            n9 = n8;
            ++n5;
        }
        if (n5 < n4) {
            CharStream.bufline[n6] = n++;
            CharStream.bufcolumn[n6] = n2 + n9;
            while (n5++ < n4) {
                n6 = n3 % CharStream.bufsize;
                CharStream.bufline[n6] = CharStream.bufline[n6] != CharStream.bufline[++n3 % CharStream.bufsize] ? n++ : n;
            }
        }
        CharStream.line = CharStream.bufline[n6];
        CharStream.column = CharStream.bufcolumn[n6];
    }

    private static final void ExpandBuff(boolean bl) {
        char[] cArray = new char[CharStream.bufsize + 2048];
        int[] nArray = new int[CharStream.bufsize + 2048];
        int[] nArray2 = new int[CharStream.bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(CharStream.buffer, CharStream.tokenBegin, cArray, 0, CharStream.bufsize - CharStream.tokenBegin);
                System.arraycopy(CharStream.buffer, 0, cArray, CharStream.bufsize - CharStream.tokenBegin, CharStream.bufpos);
                CharStream.buffer = cArray;
                System.arraycopy(CharStream.bufline, CharStream.tokenBegin, nArray, 0, CharStream.bufsize - CharStream.tokenBegin);
                System.arraycopy(CharStream.bufline, 0, nArray, CharStream.bufsize - CharStream.tokenBegin, CharStream.bufpos);
                CharStream.bufline = nArray;
                System.arraycopy(CharStream.bufcolumn, CharStream.tokenBegin, nArray2, 0, CharStream.bufsize - CharStream.tokenBegin);
                System.arraycopy(CharStream.bufcolumn, 0, nArray2, CharStream.bufsize - CharStream.tokenBegin, CharStream.bufpos);
                CharStream.bufcolumn = nArray2;
                CharStream.bufpos += CharStream.bufsize - CharStream.tokenBegin;
            } else {
                System.arraycopy(CharStream.buffer, CharStream.tokenBegin, cArray, 0, CharStream.bufsize - CharStream.tokenBegin);
                CharStream.buffer = cArray;
                System.arraycopy(CharStream.bufline, CharStream.tokenBegin, nArray, 0, CharStream.bufsize - CharStream.tokenBegin);
                CharStream.bufline = nArray;
                System.arraycopy(CharStream.bufcolumn, CharStream.tokenBegin, nArray2, 0, CharStream.bufsize - CharStream.tokenBegin);
                CharStream.bufcolumn = nArray2;
                CharStream.bufpos -= CharStream.tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        CharStream.available = CharStream.bufsize += 2048;
        CharStream.tokenBegin = 0;
    }

    private static final void FillBuff() throws IOException {
        if (CharStream.maxNextCharInd == 4096) {
            nextCharInd = 0;
            CharStream.maxNextCharInd = 0;
        }
        try {
            int n = CharStream.inputStream.read(nextCharBuf, CharStream.maxNextCharInd, 4096 - CharStream.maxNextCharInd);
            if (n == -1) {
                CharStream.inputStream.close();
                throw new IOException();
            }
            CharStream.maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            if (CharStream.bufpos != 0) {
                --CharStream.bufpos;
                UCode_CharStream.backup(0);
            } else {
                CharStream.bufline[CharStream.bufpos] = CharStream.line;
                CharStream.bufcolumn[CharStream.bufpos] = CharStream.column;
            }
            if (CharStream.tokenBegin == -1) {
                CharStream.tokenBegin = CharStream.bufpos;
            }
            throw iOException;
        }
    }

    private static final char ReadChar() throws IOException {
        if (++nextCharInd >= CharStream.maxNextCharInd) {
            UCode_CharStream.FillBuff();
        }
        char c = (char)(nextCharBuf[nextCharInd] << 8);
        if (++nextCharInd >= CharStream.maxNextCharInd) {
            UCode_CharStream.FillBuff();
        }
        return (char)(c | 0xFF & nextCharBuf[nextCharInd]);
    }

    private static final void UpdateLineColumn(char c) {
        ++CharStream.column;
        if (CharStream.prevCharIsLF) {
            CharStream.prevCharIsLF = false;
            CharStream.column = 1;
            ++CharStream.line;
        } else if (CharStream.prevCharIsCR) {
            CharStream.prevCharIsCR = false;
            if (c == '\n') {
                CharStream.prevCharIsLF = true;
            } else {
                CharStream.column = 1;
                ++CharStream.line;
            }
        }
        switch (c) {
            case '\r': {
                CharStream.prevCharIsCR = true;
                break;
            }
            case '\n': {
                CharStream.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --CharStream.column;
                CharStream.column += 8 - (CharStream.column & 7);
                break;
            }
        }
    }

    static {
        nextCharInd = -1;
    }
}

