/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.SimpleNode;

public class ASTName
extends SimpleNode
implements Cloneable {
    private Vector name = new Vector();

    public ASTName(int n) {
        super(n);
    }

    public ASTName(JavaParser javaParser, int n) {
        super(javaParser, n);
    }

    public void setNamePart(int n, String string) {
        this.name.setElementAt(string, n);
    }

    public String getNamePart(int n) {
        if (n >= 0 && n < this.name.size()) {
            return (String)this.name.elementAt(n);
        }
        return null;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.name.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(".");
            }
            stringBuffer.append((String)enumeration.nextElement());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public int getNameSize() {
        return this.name.size();
    }

    public void insertNamePart(int n, String string) {
        this.name.insertElementAt(string, n);
    }

    public void addNamePart(String string) {
        this.name.addElement(string.intern());
    }

    public String toString() {
        return super.toString() + " [" + this.getName() + "]";
    }

    public void fromString(String string) {
        this.name.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.name.addElement(string2);
        }
    }

    public boolean equals(Object object) {
        ASTName aSTName;
        if (object == this) {
            return true;
        }
        if (object instanceof ASTName && (aSTName = (ASTName)object).getNameSize() == this.getNameSize()) {
            return this.startsWith(aSTName);
        }
        return false;
    }

    public boolean startsWith(ASTName aSTName) {
        if (aSTName.getNameSize() > this.getNameSize()) {
            return false;
        }
        int n = Math.min(aSTName.getNameSize(), this.getNameSize());
        int n2 = 0;
        while (n2 < n) {
            if (!this.getNamePart(n2).equals(aSTName.getNamePart(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public ASTName changeStartingPart(ASTName aSTName, ASTName aSTName2) {
        int n;
        ASTName aSTName3 = new ASTName(0);
        int n2 = aSTName2.getNameSize();
        int n3 = 0;
        while (n3 < n2) {
            aSTName3.addNamePart(aSTName2.getNamePart(n3));
            ++n3;
        }
        int n4 = this.getNameSize();
        int n5 = n = aSTName.getNameSize();
        while (n5 < n4) {
            aSTName3.addNamePart(this.getNamePart(n5));
            ++n5;
        }
        return aSTName3;
    }

    public Object clone() {
        ASTName aSTName = new ASTName(0);
        int n = this.getNameSize();
        int n2 = 0;
        while (n2 < n) {
            aSTName.addNamePart(this.getNamePart(n2));
            ++n2;
        }
        return aSTName;
    }

    public Object jjtAccept(JavaParserVisitor javaParserVisitor, Object object) {
        return javaParserVisitor.visit(this, object);
    }
}

