/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.text.MessageFormat;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ForceJavadocComments;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavaDocableImpl;
import org.acm.seguin.pretty.JavadocTags;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.ai.RequiredTags;
import org.acm.seguin.util.FileSettings;

public class ASTConstructorDeclaration
extends SimpleNode
implements JavaDocable {
    private JavaDocableImpl jdi;
    private ModifierHolder modifiers = new ModifierHolder();
    private String name;

    public ASTConstructorDeclaration(int n) {
        super(n);
        this.jdi = new JavaDocableImpl();
    }

    public ASTConstructorDeclaration(JavaParser javaParser, int n) {
        super(javaParser, n);
        this.jdi = new JavaDocableImpl();
    }

    public void setName(String string) {
        this.name = string.intern();
    }

    public ModifierHolder getModifiers() {
        return this.modifiers;
    }

    public String getModifiersString() {
        return this.modifiers.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    public boolean isExplicit() {
        return this.modifiers.isExplicit();
    }

    public boolean isFinal() {
        return this.modifiers.isFinal();
    }

    public boolean isInterface() {
        return this.modifiers.isInterface();
    }

    public boolean isNative() {
        return this.modifiers.isNative();
    }

    public boolean isPrivate() {
        return this.modifiers.isPrivate();
    }

    public boolean isProtected() {
        return this.modifiers.isProtected();
    }

    public boolean isPublic() {
        return this.modifiers.isPublic();
    }

    public boolean isRequired() {
        ForceJavadocComments forceJavadocComments = new ForceJavadocComments();
        return this.jdi.isRequired() && forceJavadocComments.isJavaDocRequired("method", this.modifiers);
    }

    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public boolean isStrict() {
        return this.modifiers.isStrict();
    }

    public boolean isSynchronized() {
        return this.modifiers.isSynchronized();
    }

    public boolean isTransient() {
        return this.modifiers.isTransient();
    }

    public boolean isVolatile() {
        return this.modifiers.isVolatile();
    }

    public void addJavaDocComponent(JavaDocComponent javaDocComponent) {
        this.jdi.addJavaDocComponent(javaDocComponent);
    }

    public void addModifier(String string) {
        this.modifiers.add(string);
    }

    public void finish() {
        SimpleNode simpleNode;
        Object object;
        JavadocTags javadocTags = JavadocTags.get();
        Object[] objectArray = new Object[]{this.getName()};
        String string = MessageFormat.format(javadocTags.getConstructorDescr(), objectArray);
        this.jdi.require("", string);
        ASTFormalParameters aSTFormalParameters = (ASTFormalParameters)this.jjtGetChild(0);
        int n = aSTFormalParameters.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            object = (ASTFormalParameter)aSTFormalParameters.jjtGetChild(n2);
            simpleNode = (ASTVariableDeclaratorId)((SimpleNode)object).jjtGetChild(1);
            this.jdi.require("@param", ((ASTVariableDeclaratorId)simpleNode).getName(), javadocTags.getParamDescr());
            ++n2;
        }
        if (this.jjtGetNumChildren() > 1 && this.jjtGetChild(1) instanceof ASTNameList) {
            object = (ASTNameList)this.jjtGetChild(1);
            n = ((SimpleNode)object).jjtGetNumChildren();
            n2 = 0;
            while (n2 < n) {
                simpleNode = (ASTName)((SimpleNode)object).jjtGetChild(n2);
                this.jdi.require(javadocTags.getExceptionTag(), ((ASTName)simpleNode).getName(), javadocTags.getExceptionDescr());
                ++n2;
            }
        }
        object = FileSettings.getSettings("Refactory", "pretty");
        RequiredTags.getTagger().addTags((FileSettings)object, "method", this.getName(), this.jdi);
    }

    public Object jjtAccept(JavaParserVisitor javaParserVisitor, Object object) {
        return javaParserVisitor.visit(this, object);
    }

    public void printJavaDocComponents(PrintData printData) {
        FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
        this.jdi.printJavaDocComponents(printData, fileSettings.getString("method.tags"));
    }

    public String toString() {
        return super.toString() + " [" + this.getModifiersString() + " " + this.getName() + "]";
    }
}

