/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.text.NumberFormat;
import org.acm.seguin.metrics.GatherData;
import org.acm.seguin.metrics.MetricsFrame;
import org.acm.seguin.metrics.PackageMetrics;
import org.acm.seguin.metrics.TypeMetrics;
import org.acm.seguin.summary.TypeSummary;

public class TypeMetricsFrame
extends MetricsFrame {
    private TypeSummary type;
    private TypeMetrics metrics;

    public TypeMetricsFrame(TypeSummary typeSummary) {
        this.type = typeSummary;
        PackageMetrics packageMetrics = new PackageMetrics("-package-");
        GatherData gatherData = new GatherData(null);
        this.metrics = (TypeMetrics)gatherData.visit(this.type, (Object)packageMetrics);
        this.descriptions = new String[]{"Description", "Statement Total", "Statement Average", "Parameter Total", "Parameter Average", "Public Method Count", "Other Method Count", "Class Metric Count", "Instance Variable Count", "Class Variable Count"};
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        this.values = new String[10];
        this.values[0] = "Value";
        this.values[1] = numberFormat.format(this.metrics.getStatementTotal());
        this.values[2] = numberFormat.format(this.metrics.getStatementAverage());
        this.values[3] = numberFormat.format(this.metrics.getParameterTotal());
        this.values[4] = numberFormat.format(this.metrics.getParameterAverage());
        this.values[5] = numberFormat.format(this.metrics.getPublicMethodCount());
        this.values[6] = numberFormat.format(this.metrics.getOtherMethodCount());
        this.values[7] = numberFormat.format(this.metrics.getClassMethodCount());
        this.values[8] = numberFormat.format(this.metrics.getInstanceVariableCount());
        this.values[9] = numberFormat.format(this.metrics.getClassVariableCount());
        this.createFrame();
    }

    protected String getTitle() {
        return "Metrics for the class " + this.type.getName();
    }
}

