/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.MethodMetrics;

public class TypeMetrics {
    private String packageName;
    private String typeName;
    private int publicMethodCount = 0;
    private int otherMethodCount = 0;
    private int classMethodCount = 0;
    private int instanceVariableCount = 0;
    private int classVariableCount = 0;
    private int statementTotal = 0;
    private int parameterTotal = 0;
    private int blockDepthTotal = 0;
    private int lineCountTotal = 0;

    public TypeMetrics(String string, String string2) {
        this.packageName = string;
        this.typeName = string2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getPublicMethodCount() {
        return this.publicMethodCount;
    }

    public int getOtherMethodCount() {
        return this.otherMethodCount;
    }

    public int getClassMethodCount() {
        return this.classMethodCount;
    }

    public int getInstanceVariableCount() {
        return this.instanceVariableCount;
    }

    public int getClassVariableCount() {
        return this.classVariableCount;
    }

    public int getStatementTotal() {
        return this.statementTotal;
    }

    public int getParameterTotal() {
        return this.parameterTotal;
    }

    public int getBlockDepthTotal() {
        return this.blockDepthTotal;
    }

    public int getLinesOfCodeTotal() {
        return this.lineCountTotal;
    }

    public double getStatementAverage() {
        double d = this.statementTotal;
        double d2 = this.publicMethodCount + this.otherMethodCount + this.classMethodCount;
        return d / d2;
    }

    public double getParameterAverage() {
        double d = this.parameterTotal;
        double d2 = this.publicMethodCount + this.otherMethodCount + this.classMethodCount;
        return d / d2;
    }

    public double getBlockDepthAverage() {
        double d = this.blockDepthTotal;
        double d2 = this.publicMethodCount + this.otherMethodCount + this.classMethodCount;
        return d / d2;
    }

    public double getLinesOfCodeAverage() {
        double d = this.lineCountTotal;
        double d2 = this.publicMethodCount + this.otherMethodCount + this.classMethodCount;
        return d / d2;
    }

    void incrPublicMethodCount() {
        ++this.publicMethodCount;
    }

    void incrOtherMethodCount() {
        ++this.otherMethodCount;
    }

    void incrClassMethodCount() {
        ++this.classMethodCount;
    }

    void incrInstanceVariableCount() {
        ++this.instanceVariableCount;
    }

    void incrClassVariableCount() {
        ++this.classVariableCount;
    }

    void add(MethodMetrics methodMetrics) {
        this.statementTotal += methodMetrics.getStatementCount();
        this.parameterTotal += methodMetrics.getParameterCount();
        this.blockDepthTotal += methodMetrics.getBlockDepth();
        this.lineCountTotal += methodMetrics.getLinesOfCode();
    }
}

