/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.MetricsReport;
import org.acm.seguin.metrics.ProjectMetrics;
import org.acm.seguin.util.TextFormatter;

public class TextReport
extends MetricsReport {
    private TextFormatter format = new TextFormatter();

    protected void reportStatement(String string, String string2, String string3, int n) {
        System.out.println("[000] " + TextFormatter.rightJustifyNumber(n, 10) + "  statements in " + string + " . " + string2 + " . " + string3);
    }

    protected void reportParameters(String string, String string2, String string3, int n) {
        System.out.println("[008] " + TextFormatter.rightJustifyNumber(n, 10) + "  parameters in " + string + " . " + string2 + " . " + string3);
    }

    protected void reportLinesOfCode(String string, String string2, String string3, int n) {
        System.out.println("[010] " + TextFormatter.rightJustifyNumber(n, 10) + "  lines of code in " + string + " . " + string2 + " . " + string3);
    }

    protected void reportBlockDepth(String string, String string2, String string3, int n) {
        System.out.println("[011] " + TextFormatter.rightJustifyNumber(n, 10) + "  block depth in " + string + " . " + string2 + " . " + string3);
    }

    protected void reportPublicMethods(String string, String string2, int n) {
        System.out.println("[001] " + TextFormatter.rightJustifyNumber(n, 10) + " public methods in " + string + " . " + string2);
    }

    protected void reportOtherMethods(String string, String string2, int n) {
        System.out.println("[002] " + TextFormatter.rightJustifyNumber(n, 10) + " non public methods in " + string + " . " + string2);
    }

    protected void reportClassMethods(String string, String string2, int n) {
        System.out.println("[003] " + TextFormatter.rightJustifyNumber(n, 10) + " static methods in " + string + " . " + string2);
    }

    protected void reportInstanceVariables(String string, String string2, int n) {
        System.out.println("[004] " + TextFormatter.rightJustifyNumber(n, 10) + " instance variables in " + string + " . " + string2);
    }

    protected void reportClassVariables(String string, String string2, int n) {
        System.out.println("[005] " + TextFormatter.rightJustifyNumber(n, 10) + " class variables in " + string + " . " + string2);
    }

    protected void reportAbstractClasses(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getAbstractClassTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[006] " + projectMetrics.getAbstractClassTotal() + " total abstract classes in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[006] Percentage:  " + 100.0 * d / d2 + "%");
    }

    protected void reportInterfaces(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getInterfaceTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[007] " + projectMetrics.getInterfaceTotal() + " total interfaces in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[007] Percentage:  " + 100.0 * d / d2 + "%");
    }

    protected void reportClasses(ProjectMetrics projectMetrics) {
    }

    protected void reportAverageStatements(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getStatementTotal();
        double d2 = projectMetrics.getMethodTotal();
        System.out.println("[000] " + projectMetrics.getStatementTotal() + " total number of statements in " + projectMetrics.getMethodTotal() + " methods.");
        System.out.println("[000] Average:  " + d / d2);
    }

    protected void reportAverageParameters(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getParameterTotal();
        double d2 = projectMetrics.getMethodTotal();
        System.out.println("[008] " + projectMetrics.getParameterTotal() + " total number of parameters in " + projectMetrics.getMethodTotal() + " methods.");
        System.out.println("[008] Average:  " + d / d2);
    }

    protected void reportAveragePublicMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getPublicMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[001] " + projectMetrics.getPublicMethodTotal() + " total public methods in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[001] Average:  " + d / d2);
    }

    protected void reportAverageOtherMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getOtherMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[002] " + projectMetrics.getOtherMethodTotal() + " total other methods in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[002] Average:  " + d / d2);
    }

    protected void reportAverageClassMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getClassMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[003] " + projectMetrics.getClassMethodTotal() + " total class methods in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[003] Average:  " + d / d2);
    }

    protected void reportAverageInstanceVariables(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getInstanceVariableTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[004] " + projectMetrics.getInstanceVariableTotal() + " total instance variables in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[004] Average:  " + d / d2);
    }

    protected void reportAverageClassVariables(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getClassVariableTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("[005] " + projectMetrics.getClassVariableTotal() + " total class variables in " + projectMetrics.getClassTotal() + " classes.");
        System.out.println("[005] Average:  " + d / d2);
    }
}

