/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.text.NumberFormat;
import org.acm.seguin.metrics.GatherData;
import org.acm.seguin.metrics.MetricsFrame;
import org.acm.seguin.metrics.PackageMetrics;
import org.acm.seguin.metrics.ProjectMetrics;
import org.acm.seguin.summary.PackageSummary;

public class PackageMetricsFrame
extends MetricsFrame {
    private PackageSummary summary;
    private PackageMetrics metrics;

    public PackageMetricsFrame(PackageSummary packageSummary) {
        this.summary = packageSummary;
        ProjectMetrics projectMetrics = new ProjectMetrics();
        GatherData gatherData = new GatherData(null);
        this.metrics = (PackageMetrics)gatherData.visit(this.summary, (Object)projectMetrics);
        this.descriptions = new String[]{"Description", "Statement Total", "Statement Average", "Parameter Total", "Parameter Average", "Public Method Total", "Public Method Average", "Other Method Total", "Other Method Average", "Class Method Total", "Class Method Average", "Instance Variable Total", "Instance Variable Average", "Class Variable Total", "Class Variable Average", "Total Classes", "Abstract Class Count", "Percent Abstract Classes", "Interface Count", "Percent Interfaces"};
        this.values = new String[20];
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        this.values[0] = "Values";
        this.values[1] = numberFormat.format(this.metrics.getStatementTotal());
        this.values[2] = numberFormat.format(this.metrics.getStatementAverage());
        this.values[3] = numberFormat.format(this.metrics.getParameterTotal());
        this.values[4] = numberFormat.format(this.metrics.getParameterAverage());
        this.values[5] = numberFormat.format(this.metrics.getPublicMethodTotal());
        this.values[6] = numberFormat.format(this.metrics.getPublicMethodAverage());
        this.values[7] = numberFormat.format(this.metrics.getOtherMethodTotal());
        this.values[8] = numberFormat.format(this.metrics.getOtherMethodAverage());
        this.values[9] = numberFormat.format(this.metrics.getClassMethodTotal());
        this.values[10] = numberFormat.format(this.metrics.getClassMethodAverage());
        this.values[11] = numberFormat.format(this.metrics.getInstanceVariableTotal());
        this.values[12] = numberFormat.format(this.metrics.getInstanceVariableAverage());
        this.values[13] = numberFormat.format(this.metrics.getClassVariableTotal());
        this.values[14] = numberFormat.format(this.metrics.getClassVariableAverage());
        this.values[15] = numberFormat.format(this.metrics.getClassTotal());
        this.values[16] = numberFormat.format(this.metrics.getAbstractClassCount());
        this.values[17] = numberFormat.format(this.metrics.getAbstractClassPercentage()) + " %";
        this.values[18] = numberFormat.format(this.metrics.getInterfaceCount());
        this.values[19] = numberFormat.format(this.metrics.getInterfacePercentage()) + " %";
        this.createFrame();
    }

    protected String getTitle() {
        return "Metrics for the package " + this.summary.getName();
    }
}

