/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.MethodMetrics;
import org.acm.seguin.metrics.ProjectMetrics;
import org.acm.seguin.metrics.TypeMetrics;

public abstract class MetricsReport {
    public void finalReport(ProjectMetrics projectMetrics) {
        this.reportAverageStatements(projectMetrics);
        this.reportAveragePublicMethods(projectMetrics);
        this.reportAverageOtherMethods(projectMetrics);
        this.reportAverageClassMethods(projectMetrics);
        this.reportAverageInstanceVariables(projectMetrics);
        this.reportAverageClassVariables(projectMetrics);
        this.reportAbstractClasses(projectMetrics);
        this.reportInterfaces(projectMetrics);
        this.reportAverageParameters(projectMetrics);
    }

    public void typeReport(TypeMetrics typeMetrics) {
        this.reportPublicMethods(typeMetrics.getPackageName(), typeMetrics.getTypeName(), typeMetrics.getPublicMethodCount());
        this.reportOtherMethods(typeMetrics.getPackageName(), typeMetrics.getTypeName(), typeMetrics.getOtherMethodCount());
        this.reportClassMethods(typeMetrics.getPackageName(), typeMetrics.getTypeName(), typeMetrics.getClassMethodCount());
        this.reportInstanceVariables(typeMetrics.getPackageName(), typeMetrics.getTypeName(), typeMetrics.getInstanceVariableCount());
        this.reportClassVariables(typeMetrics.getPackageName(), typeMetrics.getTypeName(), typeMetrics.getClassVariableCount());
    }

    public void methodReport(MethodMetrics methodMetrics) {
        this.reportStatement(methodMetrics.getPackageName(), methodMetrics.getTypeName(), methodMetrics.getMethodName(), methodMetrics.getStatementCount());
        this.reportParameters(methodMetrics.getPackageName(), methodMetrics.getTypeName(), methodMetrics.getMethodName(), methodMetrics.getParameterCount());
        this.reportLinesOfCode(methodMetrics.getPackageName(), methodMetrics.getTypeName(), methodMetrics.getMethodName(), methodMetrics.getLinesOfCode());
        this.reportBlockDepth(methodMetrics.getPackageName(), methodMetrics.getTypeName(), methodMetrics.getMethodName(), methodMetrics.getBlockDepth());
    }

    protected abstract void reportStatement(String var1, String var2, String var3, int var4);

    protected abstract void reportParameters(String var1, String var2, String var3, int var4);

    protected abstract void reportLinesOfCode(String var1, String var2, String var3, int var4);

    protected abstract void reportBlockDepth(String var1, String var2, String var3, int var4);

    protected abstract void reportAverageStatements(ProjectMetrics var1);

    protected abstract void reportAverageParameters(ProjectMetrics var1);

    protected abstract void reportPublicMethods(String var1, String var2, int var3);

    protected abstract void reportOtherMethods(String var1, String var2, int var3);

    protected abstract void reportClassMethods(String var1, String var2, int var3);

    protected abstract void reportInstanceVariables(String var1, String var2, int var3);

    protected abstract void reportClassVariables(String var1, String var2, int var3);

    protected abstract void reportAbstractClasses(ProjectMetrics var1);

    protected abstract void reportInterfaces(ProjectMetrics var1);

    protected abstract void reportClasses(ProjectMetrics var1);

    protected abstract void reportAveragePublicMethods(ProjectMetrics var1);

    protected abstract void reportAverageOtherMethods(ProjectMetrics var1);

    protected abstract void reportAverageClassMethods(ProjectMetrics var1);

    protected abstract void reportAverageInstanceVariables(ProjectMetrics var1);

    protected abstract void reportAverageClassVariables(ProjectMetrics var1);
}

