/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.io.File;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.metrics.LineCounter;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class LCTraversal
extends DirectoryTreeTraversal {
    private long total = 0L;
    private int fileCount = 0;

    public LCTraversal(String string) {
        super(string);
    }

    public void go() {
        super.go();
        long l = this.total;
        if (l < 10L) {
            System.out.print("      " + l);
        } else if (l < 100L) {
            System.out.print("     " + l);
        } else if (l < 1000L) {
            System.out.print("    " + l);
        } else if (l < 10000L) {
            System.out.print("   " + l);
        } else if (l < 100000L) {
            System.out.print("  " + l);
        } else {
            System.out.print(" " + l);
        }
        System.out.println(" total lines in " + this.fileCount + " files");
        double d = l;
        double d2 = this.fileCount;
        System.out.println("Average:  " + d / d2);
    }

    protected boolean isTarget(File file) {
        String string = file.getName().toLowerCase();
        return string.indexOf(".java") >= 0 || string.indexOf(".h") >= 0 || string.indexOf(".cpp") >= 0;
    }

    protected void visit(File file) {
        int n = new LineCounter(file).printMessage();
        this.total += (long)n;
        ++this.fileCount;
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
        if (stringArray.length == 0) {
            System.out.println("Syntax:  java org.acm.seguin.metrics.LCTraversal <directory>");
            return;
        }
        new LCTraversal(stringArray[0]).go();
    }
}

