/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.util.Iterator;
import org.acm.seguin.metrics.MethodMetrics;
import org.acm.seguin.metrics.MetricsReport;
import org.acm.seguin.metrics.PackageMetrics;
import org.acm.seguin.metrics.ProjectMetrics;
import org.acm.seguin.metrics.TextReport;
import org.acm.seguin.metrics.TypeMetrics;
import org.acm.seguin.summary.FieldAccessSummary;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.LocalVariableSummary;
import org.acm.seguin.summary.MessageSendSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.VariableSummary;

public class GatherData
implements SummaryVisitor {
    private MetricsReport metricsReport;

    public GatherData(MetricsReport metricsReport) {
        this.metricsReport = metricsReport;
    }

    public Object visit(Object object) {
        ProjectMetrics projectMetrics = new ProjectMetrics();
        Iterator iterator = PackageSummary.getAllPackages();
        if (iterator != null) {
            while (iterator.hasNext()) {
                PackageSummary packageSummary = (PackageSummary)iterator.next();
                packageSummary.accept(this, projectMetrics);
            }
        }
        return projectMetrics;
    }

    public Object visit(Summary summary, Object object) {
        return object;
    }

    public Object visit(PackageSummary packageSummary, Object object) {
        Object object2;
        PackageMetrics packageMetrics = new PackageMetrics(packageSummary.getName());
        Iterator iterator = packageSummary.getFileSummaries();
        if (iterator != null) {
            while (iterator.hasNext()) {
                object2 = (FileSummary)iterator.next();
                ((FileSummary)object2).accept(this, packageMetrics);
            }
        }
        object2 = (ProjectMetrics)object;
        ((ProjectMetrics)object2).add(packageMetrics);
        return packageMetrics;
    }

    public Object visit(FileSummary fileSummary, Object object) {
        if (fileSummary.getFile() == null) {
            return object;
        }
        Iterator iterator = fileSummary.getTypes();
        if (iterator != null) {
            while (iterator.hasNext()) {
                TypeSummary typeSummary = (TypeSummary)iterator.next();
                typeSummary.accept(this, object);
            }
        }
        return object;
    }

    public Object visit(ImportSummary importSummary, Object object) {
        return object;
    }

    public Object visit(TypeSummary typeSummary, Object object) {
        Summary summary;
        PackageMetrics packageMetrics = (PackageMetrics)object;
        TypeMetrics typeMetrics = new TypeMetrics(packageMetrics.getPackageName(), typeSummary.getName());
        Iterator iterator = typeSummary.getFields();
        if (iterator != null) {
            while (iterator.hasNext()) {
                summary = (FieldSummary)iterator.next();
                if (((FieldSummary)summary).getModifiers().isStatic()) {
                    typeMetrics.incrClassVariableCount();
                    continue;
                }
                typeMetrics.incrInstanceVariableCount();
            }
        }
        if ((iterator = typeSummary.getMethods()) != null) {
            while (iterator.hasNext()) {
                summary = (MethodSummary)iterator.next();
                ((MethodSummary)summary).accept(this, typeMetrics);
                if (((MethodSummary)summary).getModifiers().isStatic()) {
                    typeMetrics.incrClassMethodCount();
                    continue;
                }
                if (((MethodSummary)summary).getModifiers().isPublic()) {
                    typeMetrics.incrPublicMethodCount();
                    continue;
                }
                typeMetrics.incrOtherMethodCount();
            }
        }
        if ((iterator = typeSummary.getTypes()) != null) {
            while (iterator.hasNext()) {
                summary = (TypeSummary)iterator.next();
                ((TypeSummary)summary).accept(this, object);
            }
        }
        if (this.metricsReport != null) {
            this.metricsReport.typeReport(typeMetrics);
        }
        packageMetrics.add(typeMetrics);
        if (typeSummary.getModifiers().isAbstract()) {
            packageMetrics.incrAbstractClassCount();
        }
        if (typeSummary.isInterface()) {
            packageMetrics.incrInterfaceCount();
        }
        return typeMetrics;
    }

    public Object visit(MethodSummary methodSummary, Object object) {
        TypeMetrics typeMetrics = (TypeMetrics)object;
        int n = methodSummary.getStatementCount();
        int n2 = methodSummary.getParameterCount();
        MethodMetrics methodMetrics = new MethodMetrics(typeMetrics.getPackageName(), typeMetrics.getTypeName(), methodSummary.getName());
        methodMetrics.setStatementCount(n);
        methodMetrics.setParameterCount(n2);
        methodMetrics.setLinesOfCode(methodSummary.getEndLine() - methodSummary.getStartLine());
        methodMetrics.setBlockDepth(methodSummary.getMaxBlockDepth());
        if (this.metricsReport != null) {
            this.metricsReport.methodReport(methodMetrics);
        }
        typeMetrics.add(methodMetrics);
        return methodMetrics;
    }

    public Object visit(FieldSummary fieldSummary, Object object) {
        return object;
    }

    public Object visit(ParameterSummary parameterSummary, Object object) {
        return object;
    }

    public Object visit(LocalVariableSummary localVariableSummary, Object object) {
        return object;
    }

    public Object visit(VariableSummary variableSummary, Object object) {
        return object;
    }

    public Object visit(TypeDeclSummary typeDeclSummary, Object object) {
        return object;
    }

    public Object visit(MessageSendSummary messageSendSummary, Object object) {
        return object;
    }

    public Object visit(FieldAccessSummary fieldAccessSummary, Object object) {
        return object;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new SummaryTraversal(System.getProperty("user.dir")).go();
        } else {
            new SummaryTraversal(stringArray[0]).go();
        }
        TextReport textReport = new TextReport();
        GatherData gatherData = new GatherData(textReport);
        ProjectMetrics projectMetrics = (ProjectMetrics)gatherData.visit("");
        textReport.finalReport(projectMetrics);
    }
}

