/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.MetricsReport;
import org.acm.seguin.metrics.ProjectMetrics;

public class CommaDelimitedReport
extends MetricsReport {
    public CommaDelimitedReport() {
        System.out.println("Metric Code,Value,Package,Type,Method,Raw/Avg");
    }

    public void finalReport(ProjectMetrics projectMetrics) {
        super.finalReport(projectMetrics);
        this.printKey();
    }

    private void printKey() {
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Key");
        System.out.println(",Metric Code,Description");
        System.out.println(",000,Statement Count");
        System.out.println(",001,Number of Public Methods");
        System.out.println(",002,Number of Other Methods");
        System.out.println(",003,Number of Class Methods");
        System.out.println(",004,Number of Instance Variables");
        System.out.println(",005,Number of Class Variables");
        System.out.println(",006,Number of Abstract Classes");
        System.out.println(",007,Number of Interfaces");
        System.out.println(",008,Parameter Count");
        System.out.println(",009,Total Classes");
        System.out.println(",010,Lines of Code");
        System.out.println(",011,Block Depth");
    }

    protected void reportStatement(String string, String string2, String string3, int n) {
        System.out.println("000," + n + "," + string + "," + string2 + "," + string3 + ",raw");
    }

    protected void reportParameters(String string, String string2, String string3, int n) {
        System.out.println("008," + n + "," + string + "," + string2 + "," + string3 + ",raw");
    }

    protected void reportLinesOfCode(String string, String string2, String string3, int n) {
        System.out.println("010," + n + "," + string + "," + string2 + "," + string3 + ",raw");
    }

    protected void reportBlockDepth(String string, String string2, String string3, int n) {
        System.out.println("011," + n + "," + string + "," + string2 + "," + string3 + ",raw");
    }

    protected void reportPublicMethods(String string, String string2, int n) {
        System.out.println("001," + n + "," + string + "," + string2 + ",---,raw");
    }

    protected void reportOtherMethods(String string, String string2, int n) {
        System.out.println("002," + n + "," + string + "," + string2 + ",---,raw");
    }

    protected void reportClassMethods(String string, String string2, int n) {
        System.out.println("003," + n + "," + string + "," + string2 + ",---,raw");
    }

    protected void reportInstanceVariables(String string, String string2, int n) {
        System.out.println("004," + n + "," + string + "," + string2 + ",---,raw");
    }

    protected void reportClassVariables(String string, String string2, int n) {
        System.out.println("005," + n + "," + string + "," + string2 + ",---,raw");
    }

    protected void reportAbstractClasses(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getAbstractClassTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("006," + projectMetrics.getAbstractClassTotal() + ",---,---,---,raw");
        System.out.println("006," + 100.0 * d / d2 + ",---,---,---,percent");
    }

    protected void reportInterfaces(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getInterfaceTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("007," + projectMetrics.getInterfaceTotal() + ",---,---,---,raw");
        System.out.println("007," + 100.0 * d / d2 + ",---,---,---,percent");
    }

    protected void reportClasses(ProjectMetrics projectMetrics) {
        System.out.println("009," + projectMetrics.getClassTotal() + ",---,---,---,raw");
    }

    protected void reportAverageStatements(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getStatementTotal();
        double d2 = projectMetrics.getMethodTotal();
        System.out.println("000," + projectMetrics.getStatementTotal() + ",---,---,---,total");
        System.out.println("000," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAverageParameters(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getParameterTotal();
        double d2 = projectMetrics.getMethodTotal();
        System.out.println("008," + projectMetrics.getParameterTotal() + ",---,---,---,total");
        System.out.println("008," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAveragePublicMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getPublicMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("001," + projectMetrics.getPublicMethodTotal() + ",---,---,---,total");
        System.out.println("001," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAverageOtherMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getOtherMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("002," + projectMetrics.getOtherMethodTotal() + ",---,---,---,total");
        System.out.println("002," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAverageClassMethods(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getClassMethodTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("003," + projectMetrics.getClassMethodTotal() + ",---,---,---,total");
        System.out.println("003," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAverageInstanceVariables(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getInstanceVariableTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("004," + projectMetrics.getInstanceVariableTotal() + ",---,---,---,total");
        System.out.println("004," + d / d2 + ",---,---,---,avg");
    }

    protected void reportAverageClassVariables(ProjectMetrics projectMetrics) {
        double d = projectMetrics.getClassVariableTotal();
        double d2 = projectMetrics.getClassTotal();
        System.out.println("005," + projectMetrics.getClassVariableTotal() + ",---,---,---,total");
        System.out.println("005," + d / d2 + ",---,---,---,avg");
    }
}

