/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.acm.seguin.awt.ExceptionPrinter;

public class FileCopy
extends Thread {
    private File source;
    private File dest;
    private boolean noisy;

    public FileCopy(File file, File file2) {
        this.source = file;
        this.dest = file2;
        this.noisy = true;
    }

    public FileCopy(File file, File file2, boolean bl) {
        this.source = file;
        this.dest = file2;
        this.noisy = bl;
    }

    public void run() {
        try {
            if (this.noisy) {
                System.out.println("Copying from " + this.source.getCanonicalPath() + " to " + this.dest.getCanonicalPath());
            }
            InputStream inputStream = this.getInputStream();
            OutputStream outputStream = this.getOutputStream();
            int n = 32768;
            byte[] byArray = new byte[n];
            int n2 = n;
            while (n2 == n) {
                n2 = inputStream.read(byArray);
                outputStream.write(byArray, 0, n2);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.source);
    }

    protected OutputStream getOutputStream() throws IOException {
        File file = this.dest.getParentFile();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        return new FileOutputStream(this.dest);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Syntax:  FileCopy source dest");
            return;
        }
        new FileCopy(new File(stringArray[0]), new File(stringArray[1])).run();
    }
}

