/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.kawa;

import com.allaire.kawa.plugin.KawaApp;
import com.allaire.kawa.plugin.KawaEditor;
import com.allaire.kawa.plugin.KawaEvent;
import com.allaire.kawa.plugin.KawaEventListener;
import com.allaire.kawa.plugin.KawaFile;
import com.allaire.kawa.plugin.KawaOutputWindow;
import java.util.Enumeration;
import org.acm.seguin.pretty.PrettyPrintFromIDE;

public class KawaPrettyPrint
extends PrettyPrintFromIDE
implements KawaEventListener {
    KawaEditor editor = null;
    static boolean installed = false;

    public KawaPrettyPrint(boolean bl) {
        if (bl && !installed) {
            KawaFile.addListener((KawaEventListener)this);
            installed = true;
        } else {
            Enumeration enumeration = KawaApp.enumerateEditors();
            while (enumeration.hasMoreElements()) {
                this.editor = (KawaEditor)enumeration.nextElement();
                if (this.editor.hasFocus()) break;
            }
            KawaEditor kawaEditor = this.editor;
            synchronized (kawaEditor) {
                try {
                    this.prettyPrintCurrentWindow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.editor = null;
        }
    }

    protected void setLineNumber(int n) {
        KawaEditor kawaEditor = this.editor;
        synchronized (kawaEditor) {
            this.editor.gotoLine((long)n, false);
        }
    }

    protected void setStringInIDE(String string) {
        KawaEditor kawaEditor = this.editor;
        synchronized (kawaEditor) {
            this.editor.setSelect(0, -1);
            this.editor.paste(string);
        }
    }

    protected int getLineNumber() {
        KawaEditor kawaEditor = this.editor;
        synchronized (kawaEditor) {
            String string = this.editor.getEditorText();
            try {
                int n = 1;
                int n2 = 0;
                while ((long)n2 < this.editor.getLineIndex(-1L)) {
                    if (string.charAt(n2) == '\n') {
                        ++n;
                    }
                    ++n2;
                }
                int n3 = n;
                return n3;
            }
            catch (Throwable throwable) {
                int n = (int)(this.editor.getLineCount() / 2L);
                return n;
            }
        }
    }

    protected String getStringFromIDE() {
        KawaEditor kawaEditor = this.editor;
        synchronized (kawaEditor) {
            String string = this.editor.getEditorText();
            return string;
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-install")) {
                    bl = true;
                }
                ++n;
            }
        }
        new KawaPrettyPrint(bl);
    }

    public void onEvent(KawaEvent kawaEvent) {
        if (kawaEvent.getID() == 5) {
            KawaOutputWindow.showWindow((boolean)true);
            KawaOutputWindow.println((String)"Please wait, formatting buffer");
            this.editor = ((KawaFile)kawaEvent.getSource()).getEditor(false);
            if (this.editor.isReadOnly()) {
                this.editor = null;
                return;
            }
            KawaEditor kawaEditor = this.editor;
            synchronized (kawaEditor) {
                try {
                    this.prettyPrintCurrentWindow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.editor = null;
        }
    }
}

