/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.jbuilder;

import com.borland.primetime.ide.Context;
import com.borland.primetime.node.Node;
import com.borland.primetime.viewer.AbstractNodeViewer;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.ide.common.ClassDiagramReloader;
import org.acm.seguin.ide.common.DividedSummaryPanel;
import org.acm.seguin.ide.jbuilder.UMLNode;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.uml.UMLPackage;

public class UMLNodeViewer
extends AbstractNodeViewer {
    private UMLPackage diagram;
    private ClassDiagramReloader reloader;

    public UMLNodeViewer(PackageSummary packageSummary, ClassDiagramReloader classDiagramReloader) {
        super(null);
        this.diagram = new UMLPackage(packageSummary);
        this.reloader = classDiagramReloader;
        this.reloader.add(this.diagram);
    }

    public UMLNodeViewer(Context context, ClassDiagramReloader classDiagramReloader) {
        super(context);
        Node node = context.getNode();
        if (node instanceof UMLNode) {
            UMLNode uMLNode = (UMLNode)node;
            this.diagram = uMLNode.getDiagram();
            if (this.diagram == null) {
                try {
                    this.diagram = new UMLPackage(uMLNode.getInputStream());
                }
                catch (IOException iOException) {
                    ExceptionPrinter.print(iOException, false);
                    this.diagram = null;
                }
                uMLNode.setDiagram(this.diagram);
            }
        } else {
            this.diagram = null;
        }
        this.reloader = classDiagramReloader;
        this.reloader.add(this.diagram);
    }

    public UMLPackage getDiagram() {
        return this.diagram;
    }

    public String getViewerTitle() {
        return "Class Diagram";
    }

    public JComponent createStructureComponent() {
        DividedSummaryPanel dividedSummaryPanel = new DividedSummaryPanel(this.diagram.getSummary(), this.diagram);
        return dividedSummaryPanel.getPane();
    }

    public JComponent createViewerComponent() {
        if (this.diagram == null) {
            return null;
        }
        JScrollPane jScrollPane = new JScrollPane(this.diagram, 22, 32);
        JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
        jScrollBar.setUnitIncrement(400);
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        jScrollBar2.setUnitIncrement(400);
        this.diagram.setScrollPane(jScrollPane);
        return jScrollPane;
    }

    public void releaseViewer() {
        try {
            this.diagram.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reloader.remove(this.diagram);
    }
}

