/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.jbuilder;

import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.DuplicateNodeException;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Url;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.acm.seguin.ide.common.MultipleDirClassDiagramReloader;
import org.acm.seguin.ide.common.PackageSelectorDialog;
import org.acm.seguin.ide.jbuilder.JBuilderAction;
import org.acm.seguin.ide.jbuilder.UMLNode;
import org.acm.seguin.ide.jbuilder.UMLNodeViewerFactory;
import org.acm.seguin.summary.PackageSummary;

public class NewClassDiagramAction
extends JBuilderAction {
    public NewClassDiagramAction() {
        ((AbstractAction)((Object)this)).putValue("Name", "New UML Class Diagram");
        ((AbstractAction)((Object)this)).putValue("ShortDescription", "New UML Class Diagram");
        ((AbstractAction)((Object)this)).putValue("LongDescription", "Creates a new UML class diagram");
    }

    private File getFile(PackageSummary packageSummary) {
        File file;
        File file2 = packageSummary.getDirectory();
        if (file2 == null) {
            file2 = new File(System.getProperty("user.home") + File.separator + ".Refactory" + File.separator + "UML");
            file2.mkdirs();
            file = new File(file2, packageSummary.getName() + ".uml");
        } else {
            file = new File(packageSummary.getDirectory(), "package.uml");
        }
        return file;
    }

    public boolean isEnabled() {
        MultipleDirClassDiagramReloader multipleDirClassDiagramReloader = UMLNodeViewerFactory.getFactory().getReloader();
        return multipleDirClassDiagramReloader.isNecessary();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project;
        Browser browser = Browser.getActiveBrowser();
        PackageSelectorDialog packageSelectorDialog = new PackageSelectorDialog((JFrame)browser);
        ((Component)packageSelectorDialog).setVisible(true);
        PackageSummary packageSummary = packageSelectorDialog.getSummary();
        if (packageSummary == null) {
            return;
        }
        Project project2 = project = browser.getActiveProject();
        File file = this.getFile(packageSummary);
        this.createFile(file, packageSummary);
        Url url = new Url(file);
        UMLNode uMLNode = (UMLNode)project.findNode(url);
        if (uMLNode == null) {
            try {
                uMLNode = new UMLNode(project, (Node)project2, url);
            }
            catch (DuplicateNodeException duplicateNodeException) {
                duplicateNodeException.printStackTrace(System.out);
            }
        }
        try {
            browser.setActiveNode((Node)uMLNode, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createFile(File file, PackageSummary packageSummary) {
        if (!file.exists()) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("V[1.1:" + packageSummary.getName() + "]\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

