/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.elixir;

import com.elixirtech.fx.DocManager;
import com.elixirtech.fx.FrameManager;
import com.elixirtech.fx.SettingManager;
import com.elixirtech.ide.project.Folder;
import com.elixirtech.msg.ApplicationBus;
import com.elixirtech.msg.Message;
import com.elixirtech.msg.MsgType;
import org.acm.seguin.ide.common.SingleDirClassDiagramReloader;
import org.acm.seguin.ide.common.SourceBrowser;
import org.acm.seguin.ide.elixir.ElixirClassDiagramLoader;
import org.acm.seguin.ide.elixir.ElixirExtractMethod;
import org.acm.seguin.ide.elixir.ElixirSourceBrowser;
import org.acm.seguin.ide.elixir.PrettyPrinterExtension;
import org.acm.seguin.ide.elixir.UMLDocManager;
import org.acm.seguin.ide.elixir.UMLViewManager;
import org.acm.seguin.ide.elixir.UndoMenuItem;
import org.acm.seguin.ide.elixir.ZoomDiagram;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.uml.loader.ReloaderSingleton;

public class RefactoryExtension
extends PrettyPrinterExtension
implements ApplicationBus.ICard {
    static String base;
    private UMLDocManager manager;

    public String getCardName() {
        return "Refactory";
    }

    public String getName() {
        return "Refactory";
    }

    public boolean destroy() {
        ApplicationBus.removeCard((ApplicationBus.ICard)this);
        return super.destroy();
    }

    public boolean init(String[] stringArray) {
        FrameManager frameManager = FrameManager.current();
        if (frameManager == null) {
            return false;
        }
        new RefactoryInstaller(true).run();
        this.manager = new UMLDocManager();
        frameManager.addDocManager((DocManager)this.manager);
        Folder.addOpenFileFilter((String)".uml", (String)"Class Diagrams (*.uml)");
        ApplicationBus.addCard((ApplicationBus.ICard)this);
        boolean bl = super.init(stringArray);
        ZoomDiagram.tenPercent();
        new UndoMenuItem();
        new ElixirClassDiagramLoader();
        try {
            new ElixirExtractMethod();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SourceBrowser.set(new ElixirSourceBrowser());
        FrameManager.current().addMenuItem("Script|JRefactory|Extract Method=((method \"extractMethod\" \"org.acm.seguin.ide.elixir.ElixirExtractMethod\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Reload Diagrams=((method \"reload\" \"org.acm.seguin.ide.elixir.ElixirClassDiagramLoader\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Undo Refactoring=((method \"undo\" \"org.acm.seguin.ide.elixir.UndoMenuItem\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Zoom|10%=((method \"tenPercent\" \"org.acm.seguin.ide.elixir.ZoomDiagram\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Zoom|25%=((method \"twentyfivePercent\" \"org.acm.seguin.ide.elixir.ZoomDiagram\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Zoom|50%=((method \"fiftyPercent\" \"org.acm.seguin.ide.elixir.ZoomDiagram\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|Zoom|100%=((method \"fullSize\" \"org.acm.seguin.ide.elixir.ZoomDiagram\"))");
        FrameManager.current().addMenuItem("Script|JRefactory|About JRefactory=((method \"run\" \"org.acm.seguin.awt.AboutBox\"))");
        return bl;
    }

    public void update(Message message) {
        SingleDirClassDiagramReloader singleDirClassDiagramReloader = this.manager.getReloader();
        MsgType msgType = message.getType();
        if (msgType == MsgType.PROJECT_OPENED) {
            base = SettingManager.getSetting((String)"WorkRoot");
            singleDirClassDiagramReloader.setRootDirectory(base);
            Thread thread = new Thread(){

                public void run() {
                    ReloaderSingleton.reload();
                }
            };
            thread.start();
        } else if (msgType == MsgType.PROJECT_CLOSED) {
            singleDirClassDiagramReloader.clear();
        } else if (msgType == MsgType.DOCUMENT_OPENED) {
            if (message.getData() instanceof UMLViewManager) {
                UMLViewManager uMLViewManager = (UMLViewManager)message.getData();
                singleDirClassDiagramReloader.add(uMLViewManager.getDiagram());
            }
        } else if (msgType == MsgType.DOCUMENT_CLOSED && message.getData() instanceof UMLViewManager) {
            UMLViewManager uMLViewManager = (UMLViewManager)message.getData();
            singleDirClassDiagramReloader.remove(uMLViewManager.getDiagram());
        }
    }

    public void veto(Message message) {
    }
}

