/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.command;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.acm.seguin.ide.command.CommandLineMenu;
import org.acm.seguin.ide.command.ExitMenuSelection;
import org.acm.seguin.ide.command.UMLFrame;
import org.acm.seguin.ide.common.PackageSelectorArea;
import org.acm.seguin.io.Saveable;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.SummaryTraversal;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.loader.Reloader;
import org.acm.seguin.uml.loader.ReloaderSingleton;

public class PackageSelectorPanel
extends PackageSelectorArea
implements ActionListener,
Saveable,
Reloader {
    private ButtonPanel buttons;
    private static PackageSelectorPanel mainPanel;
    protected String rootDir = null;
    private HashMap viewList;

    protected PackageSelectorPanel(String string) {
        this.setRootDirectory(string);
        ReloaderSingleton.register(this);
        ReloaderSingleton.reload();
        this.buttons = new ButtonPanel(this);
        this.createFrame();
    }

    protected void setRootDirectory(String string) {
        this.rootDir = string == null ? System.getProperty("user.dir") : string;
    }

    public static PackageSelectorPanel getMainPanel(String string) {
        if (mainPanel == null) {
            if (string == null) {
                return null;
            }
            mainPanel = new PackageSelectorPanel(string);
        }
        mainPanel.setVisible(true);
        return mainPanel;
    }

    protected UMLFrame getPackage(PackageSummary packageSummary) {
        return (UMLFrame)this.viewList.get(packageSummary);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Show")) {
            Object[] objectArray = this.listbox.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                PackageSummary packageSummary = (PackageSummary)objectArray[n];
                this.showSummary(packageSummary);
                ++n;
            }
        } else if (string.equals("Hide")) {
            Object[] objectArray = this.listbox.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                PackageSummary packageSummary = (PackageSummary)objectArray[n];
                this.hideSummary(packageSummary);
                ++n;
            }
        } else if (string.equals("Reload")) {
            ReloaderSingleton.reload();
        }
    }

    protected void addPackage(PackageSummary packageSummary, UMLFrame uMLFrame) {
        this.viewList.put(packageSummary, uMLFrame);
    }

    private void createFrame() {
        JFrame jFrame = new JFrame("Package Selector");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = this.getScrollPane();
        jScrollPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.buttons, "East");
        jFrame.getContentPane().add(jPanel);
        CommandLineMenu commandLineMenu = new CommandLineMenu();
        jFrame.setJMenuBar(commandLineMenu.getMenuBar(this));
        jFrame.addWindowListener(new ExitMenuSelection());
        ((Component)jFrame).setSize(350, 350);
        ((Component)jFrame).setVisible(true);
    }

    private void createNewView(PackageSummary packageSummary) {
        UMLFrame uMLFrame = new UMLFrame(packageSummary);
        this.addPackage(packageSummary, uMLFrame);
    }

    private void hideSummary(PackageSummary packageSummary) {
        UMLFrame uMLFrame = this.getPackage(packageSummary);
        ((Component)uMLFrame).setVisible(false);
    }

    public void loadPackages() {
        this.loadSummaries();
        super.loadPackages();
        UMLPackage uMLPackage = null;
        PackageSummary packageSummary = null;
        if (this.viewList == null) {
            this.viewList = new HashMap();
            return;
        }
        Iterator iterator = this.viewList.keySet().iterator();
        while (iterator.hasNext()) {
            packageSummary = (PackageSummary)iterator.next();
            uMLPackage = this.getPackage(packageSummary).getUmlPackage();
            uMLPackage.reload();
        }
    }

    public void loadSummaries() {
        new SummaryTraversal(this.rootDir).go();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Syntax:  java org.acm.seguin.uml.PackageSelectorPanel <dir>");
            return;
        }
        PackageSelectorPanel packageSelectorPanel = PackageSelectorPanel.getMainPanel(stringArray[0]);
        ReloaderSingleton.register(packageSelectorPanel);
    }

    public void reload() {
        this.loadPackages();
    }

    public void save() throws IOException {
        Iterator iterator = this.viewList.keySet().iterator();
        while (iterator.hasNext()) {
            PackageSummary packageSummary = (PackageSummary)iterator.next();
            UMLPackage uMLPackage = this.getPackage(packageSummary).getUmlPackage();
            uMLPackage.save();
        }
    }

    private void showSummary(PackageSummary packageSummary) {
        UMLFrame uMLFrame = this.getPackage(packageSummary);
        if (uMLFrame == null && packageSummary.getFileSummaries() != null) {
            this.createNewView(packageSummary);
        } else if (packageSummary.getFileSummaries() != null) {
            uMLFrame.getUmlPackage().reload();
            ((Component)uMLFrame).setVisible(true);
        }
    }

    private class ButtonPanel
    extends JPanel {
        private ActionListener listener;

        public ButtonPanel(ActionListener actionListener) {
            this.listener = actionListener;
            this.init();
            this.setSize(this.getPreferredSize());
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(110, 170);
        }

        private void init() {
            this.setLayout(null);
            JButton jButton = new JButton("Show");
            jButton.setBounds(0, 10, 100, 25);
            this.add(jButton);
            jButton.addActionListener(this.listener);
            JButton jButton2 = new JButton("Hide");
            jButton2.setBounds(0, 50, 100, 25);
            this.add(jButton2);
            jButton2.addActionListener(this.listener);
            JButton jButton3 = new JButton("Reload");
            jButton3.setBounds(0, 90, 100, 25);
            this.add(jButton3);
            jButton3.addActionListener(this.listener);
            JButton jButton4 = new JButton("Reload All");
            jButton4.setBounds(0, 130, 100, 25);
            jButton4.setEnabled(false);
            this.add(jButton4);
        }
    }
}

