/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.command;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.acm.seguin.ide.command.ExitMenuSelection;
import org.acm.seguin.ide.command.ZoomAdapter;
import org.acm.seguin.ide.common.UndoAdapter;
import org.acm.seguin.io.Saveable;
import org.acm.seguin.uml.SaveMenuSelection;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.jpg.SaveAdapter;
import org.acm.seguin.uml.line.LinedPanel;
import org.acm.seguin.uml.print.PrintAdapter;
import org.acm.seguin.uml.print.PrintSetupAdapter;

class CommandLineMenu {
    CommandLineMenu() {
    }

    public JMenuBar getMenuBar(JPanel jPanel) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu(jPanel));
        jMenuBar.add(this.createEditMenu());
        if (jPanel instanceof LinedPanel) {
            jMenuBar.add(this.createZoomMenu(jPanel));
        }
        return jMenuBar;
    }

    private JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        JMenuItem jMenuItem = new JMenuItem("Undo Refactoring");
        jMenuItem.addActionListener(new UndoAdapter());
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu createFileMenu(JPanel jPanel) {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Save");
        if (jPanel instanceof Saveable) {
            jMenuItem.addActionListener(new SaveMenuSelection((Saveable)((Object)jPanel)));
        } else {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("JPG");
        if (jPanel instanceof UMLPackage) {
            jMenuItem2.addActionListener(new SaveAdapter((UMLPackage)jPanel));
        } else {
            jMenuItem2.setEnabled(false);
        }
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Print Setup");
        jMenuItem3.addActionListener(new PrintSetupAdapter());
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Print");
        if (jPanel instanceof UMLPackage) {
            jMenuItem4.addActionListener(new PrintAdapter((UMLPackage)jPanel));
        } else {
            jMenuItem4.setEnabled(false);
        }
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.addActionListener(new ExitMenuSelection());
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    private JMenu createZoomMenu(JPanel jPanel) {
        LinedPanel linedPanel = (LinedPanel)jPanel;
        JMenu jMenu = new JMenu("Zoom");
        JMenuItem jMenuItem = new JMenuItem("10%");
        jMenuItem.addActionListener(new ZoomAdapter(linedPanel, 0.1));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("25%");
        jMenuItem2.addActionListener(new ZoomAdapter(linedPanel, 0.25));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("50%");
        jMenuItem3.addActionListener(new ZoomAdapter(linedPanel, 0.5));
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("100%");
        jMenuItem4.addActionListener(new ZoomAdapter(linedPanel, 1.0));
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("200%");
        jMenuItem5.addActionListener(new ZoomAdapter(linedPanel, 2.0));
        jMenu.add(jMenuItem5);
        return jMenu;
    }
}

