/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class CVSUtil {
    private HashMap entries = new HashMap();
    private static TimeZone tz = TimeZone.getTimeZone("GMT");

    public boolean isFileModified(File file) {
        CVSEntry entry = (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
        if (entry == null && (entry = this.loadEntriesFileFor(file)) == null) {
            return true;
        }
        return !entry.equalsTime(file.lastModified());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CVSEntry loadEntriesFileFor(File file) {
        File workingDirectory = file.getParentFile();
        int linenum = 0;
        String line = null;
        BufferedReader in = null;
        File entriesFile = new File(workingDirectory + "/CVS/Entries");
        if (!entriesFile.exists()) {
            return null;
        }
        try {
            try {
                in = new BufferedReader(new FileReader(entriesFile));
                linenum = 1;
                while (true) {
                    try {
                        line = in.readLine();
                    }
                    catch (IOException ex) {
                        line = null;
                        break;
                    }
                    if (line == null) break;
                    if (line.startsWith("/")) {
                        try {
                            CVSEntry entry = CVSEntry.parseEntryLine(workingDirectory, line);
                            this.entries.put(entry.getFileName(), entry);
                        }
                        catch (ParseException ex) {
                            System.err.println("Bad 'Entries' line " + linenum + ", '" + line + "' - " + ex.getMessage());
                        }
                    }
                    ++linenum;
                }
                Object var9_11 = null;
                if (in == null) return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
            }
            catch (IOException ex) {
                return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        in.close();
        return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
    }

    public static class CVSEntry {
        private Date date;
        private String fileName;

        public void setTimestamp(String timeStamp) {
            String tstamp = new String(timeStamp);
            String conflict = null;
            if (tstamp.length() < 1) {
                this.date = null;
            } else if (tstamp.startsWith("+")) {
                conflict = tstamp.substring(1);
                if (conflict.equals("=")) {
                    conflict = "";
                }
            } else {
                int index = tstamp.indexOf(43);
                if (index < 0) {
                    this.date = null;
                } else {
                    conflict = tstamp.substring(index + 1);
                    tstamp = tstamp.substring(0, index);
                    this.date = null;
                    if (tstamp.equals("Result of merge")) {
                        if ((timeStamp == null || timeStamp.length() == 0) && conflict.length() > 0) {
                            timeStamp = conflict;
                        }
                    } else {
                        timeStamp = tstamp;
                    }
                }
            }
            if (this.date == null && timeStamp.length() > 0) {
                try {
                    this.date = this.parseTimestamp(timeStamp);
                }
                catch (ParseException ex) {
                    this.date = null;
                }
            }
        }

        private Date getDate() {
            return this.date;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean equals(Object src) {
            if (src instanceof CVSEntry) {
                return this.fileName.equals(((CVSEntry)src).getFileName());
            }
            return false;
        }

        public boolean equalsTime(long time) {
            if (this.date == null) {
                return false;
            }
            return this.date.getTime() > time ? this.date.getTime() - time < 1000L : time - this.date.getTime() < 1000L;
        }

        public int hashCode() {
            return this.fileName.hashCode();
        }

        private static String parseAToken(StringTokenizer toker) {
            String token = null;
            try {
                token = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                token = null;
            }
            return token;
        }

        public static CVSEntry parseEntryLine(File parent_dir, String parseLine) throws ParseException {
            String token = null;
            String nameToke = null;
            String versionToke = null;
            String conflictToke = null;
            String optionsToke = null;
            String tagToke = null;
            StringTokenizer toker = new StringTokenizer(parseLine, "/", true);
            int tokeCount = toker.countTokens();
            if (tokeCount < 6) {
                throw new ParseException("not enough tokens in entries line (min 6, parsed " + tokeCount + ")", 0);
            }
            token = CVSEntry.parseAToken(toker);
            nameToke = CVSEntry.parseAToken(toker);
            if (nameToke == null) {
                throw new ParseException("could not parse entry name", 0);
            }
            if (nameToke.equals("/")) {
                throw new ParseException("entry has an empty name", 0);
            }
            token = CVSEntry.parseAToken(toker);
            if (token == null || !token.equals("/")) {
                throw new ParseException("could not parse version's starting slash", 0);
            }
            versionToke = CVSEntry.parseAToken(toker);
            if (versionToke == null) {
                throw new ParseException("out of tokens getting version field", 0);
            }
            if (versionToke.equals("/")) {
                versionToke = "";
            } else {
                token = CVSEntry.parseAToken(toker);
                if (token == null || !token.equals("/")) {
                    throw new ParseException("could not parse conflict's starting slash", 0);
                }
            }
            conflictToke = CVSEntry.parseAToken(toker);
            if (conflictToke == null) {
                throw new ParseException("out of tokens getting conflict field", 0);
            }
            if (conflictToke.equals("/")) {
                conflictToke = "";
            } else {
                token = CVSEntry.parseAToken(toker);
                if (token == null || !token.equals("/")) {
                    throw new ParseException("could not parse options' starting slash", 0);
                }
            }
            optionsToke = CVSEntry.parseAToken(toker);
            if (optionsToke == null) {
                throw new ParseException("out of tokens getting options field", 0);
            }
            if (optionsToke.equals("/")) {
                optionsToke = "";
            } else {
                token = CVSEntry.parseAToken(toker);
                if (token == null || !token.equals("/")) {
                    throw new ParseException("could not parse tag's starting slash", 0);
                }
            }
            tagToke = CVSEntry.parseAToken(toker);
            if (tagToke == null || tagToke.equals("/")) {
                tagToke = "";
            }
            CVSEntry entry = new CVSEntry();
            nameToke = parent_dir.toString() + "/" + nameToke;
            entry.fileName = nameToke.replace(File.separatorChar, '/');
            entry.setTimestamp(conflictToke);
            return entry;
        }

        public Date parseTimestamp(String source) throws ParseException {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
            dateFormat.setTimeZone(tz);
            Date result = dateFormat.parse(source, new ParsePosition(0));
            if (result == null) {
                throw new ParseException("invalid timestamp '" + source + "'", 0);
            }
            return result;
        }

        public String toString() {
            return "fileName=" + this.fileName + " date=" + this.date;
        }
    }
}

