/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.MoveClass;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class Repackage {
    private boolean setPackage = false;
    private boolean atLeastOneClass = false;
    private MoveClass moveClass;

    public boolean init(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-dir")) {
                this.moveClass.setDirectory(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-package")) {
                this.moveClass.setDestinationPackage(stringArray[n + 1]);
                n += 2;
                this.setPackage = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-nopackage")) {
                this.moveClass.setDestinationPackage("");
                ++n;
                this.setPackage = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-file")) {
                String string = stringArray[n + 1];
                this.load(string);
                n += 2;
                this.atLeastOneClass = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equalsIgnoreCase("--help")) {
                this.printHelpMessage();
                ++n;
                return false;
            }
            this.moveClass.add(stringArray[n]);
            ++n;
            this.atLeastOneClass = true;
        }
        return this.atLeastOneClass && this.setPackage;
    }

    public void run(String[] stringArray) throws RefactoringException {
        this.moveClass = RefactoringFactory.get().moveClass();
        if (stringArray.length == 0) {
            this.printHelpMessage();
        }
        try {
            if (this.init(stringArray)) {
                this.moveClass.run();
            }
        }
        catch (Exception exception) {
            this.printHelpMessage();
        }
    }

    protected void printHelpMessage() {
        System.out.println("Syntax:  java Repackage \\ ");
        System.out.println("        [-dir <dir>] [-help | --help] ");
        System.out.println("        [-package <packagename> | -nopackage] (<file.java>)*");
        System.out.println("");
        System.out.println("  where:");
        System.out.println("    <dir>        is the name of the directory containing the files");
        System.out.println("    <package>    is the name of the new package");
        System.out.println("    <nopackage>  is the way of flatening package hieracrhy");
        System.out.println("    <file.java>  is the name of the java file(s) separated");
        System.out.println("                 by whitespace to be moved");
        System.out.println("    The syntax is case insensitive. ");
    }

    private void load(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                System.out.println("Should have atleast one file name");
                this.printHelpMessage();
            }
            while (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    System.out.println("Adding:  " + string3);
                    this.moveClass.add(string3);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            new RefactoryInstaller(true).run();
            new Repackage().run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        System.exit(0);
    }
}

