/*
 * Decompiled with CFR 0.152.
 */
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.RenameClassRefactoring;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class RenameType {
    private RenameClassRefactoring renameClass;

    public boolean init(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-dir")) {
                this.renameClass.setDirectory(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-help") || stringArray[n].equalsIgnoreCase("--help")) {
                this.printHelpMessage();
                ++n;
                return false;
            }
            if (stringArray[n].equalsIgnoreCase("-from")) {
                this.renameClass.setOldClassName(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-to")) {
                this.renameClass.setNewClassName(stringArray[n + 1]);
                n += 2;
                continue;
            }
            System.out.println("Unknown argument:  " + stringArray[n]);
            ++n;
        }
        return true;
    }

    public void run(String[] stringArray) {
        this.renameClass = RefactoringFactory.get().renameClass();
        if (stringArray.length == 0) {
            this.printHelpMessage();
        }
        try {
            if (this.init(stringArray)) {
                try {
                    this.renameClass.run();
                }
                catch (RefactoringException refactoringException) {
                    System.out.println(refactoringException.getMessage());
                }
            }
        }
        catch (Exception exception) {
            this.printHelpMessage();
        }
    }

    protected void printHelpMessage() {
        System.out.println("Syntax:  java RenameType \\ ");
        System.out.println("        [-dir <dir>] [-help | --help] ");
        System.out.println("        -from <className> -to <className>");
        System.out.println("");
        System.out.println("  where:");
        System.out.println("    <dir>        is the name of the directory containing the files");
        System.out.println("    <className>  is the name of the class");
        System.out.println("    The syntax is case insensitive. ");
    }

    public static void main(String[] stringArray) {
        try {
            new RefactoryInstaller(true).run();
            new RenameType().run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }
}

