/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.parser.factory.StdInParserFactory;
import org.acm.seguin.pretty.PrettyPrintVisitor;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.pretty.line.LineNumberingData;
import org.acm.seguin.tools.install.RefactoryInstaller;

public class LineNumberTool {
    private String dest = null;
    private ArrayList inputList = new ArrayList();
    private OutputStream out = null;

    private OutputStream getOutputStream(int n, String string) {
        OutputStream outputStream = null;
        if (this.dest == null) {
            outputStream = System.out;
        } else {
            try {
                outputStream = new FileOutputStream(this.dest);
            }
            catch (IOException iOException) {
                outputStream = System.out;
            }
        }
        return outputStream;
    }

    private PrintData getPrintData(int n, PrintData printData) {
        if (printData == null) {
            this.out = this.getOutputStream(n, null);
            return new LineNumberingData(this.out);
        }
        printData.flush();
        try {
            this.out.write(12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return printData;
    }

    private SimpleNode getRoot(int n) {
        ParserFactory parserFactory;
        if (this.inputList.size() > n) {
            File file = new File((String)this.inputList.get(n));
            parserFactory = new FileParserFactory(file);
        } else {
            parserFactory = new StdInParserFactory();
        }
        return parserFactory.getAbstractSyntaxTree(true);
    }

    protected void init(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals("-help")) {
                System.out.println("Pretty Printer Version 1.0.  Has the following inputs");
                System.out.println("         java LineNumberTool [-out filename] (inputfile)*");
                System.out.println("OR");
                System.out.println("         java LineNumberTool [-out filename] < inputfile");
                System.out.println("where");
                System.out.println("         -out filename     Output to the file or directory");
            } else if (stringArray[n2].equals("-out")) {
                this.dest = stringArray[++n2];
            } else {
                this.inputList.add(stringArray[n2]);
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        new RefactoryInstaller(false).run();
        try {
            LineNumberTool lineNumberTool = new LineNumberTool();
            lineNumberTool.init(stringArray);
            lineNumberTool.run();
        }
        catch (Throwable throwable) {
            if (throwable == null) {
                System.out.println("We have caught a null throwable");
            }
            System.out.println("t is a " + throwable.getClass().getName());
            System.out.println("t has a message " + throwable.getMessage());
            throwable.printStackTrace(System.out);
        }
    }

    protected void run() {
        int n = this.inputList.size();
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        PrintData printData = null;
        int n2 = 0;
        while (n2 < n || n2 == 0) {
            printData = this.getPrintData(n2, printData);
            prettyPrintVisitor.visit(this.getRoot(n2), (Object)printData);
            printData.flush();
            ++n2;
        }
        printData.close();
    }
}

