/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.xslt;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;
import org.xml.sax.InputSource;
import webwork.util.ValueStack;
import webwork.view.xslt.SAXAdapter.XMLReaderAdapter;
import webwork.view.xslt.SAXAdapter.XMLWalker;

public class XSLTServlet
extends HttpServlet {
    public static final String STACK_NAME = "webwork.result";
    public static final String ROOT_ELEMENT_NAME = "result";
    protected static Category log = Category.getInstance((Class)(class$webwork$view$xslt$XSLTServlet != null ? class$webwork$view$xslt$XSLTServlet : (class$webwork$view$xslt$XSLTServlet = XSLTServlet.class$("webwork.view.xslt.XSLTServlet"))));
    private TransformerFactory tfactory;
    private Map templatesCache;
    private XMLWalker xmlWalker;
    static /* synthetic */ Class class$webwork$view$xslt$XSLTServlet;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected Templates getTemplates(HttpServletRequest request) throws TransformerException, IOException {
        String path = this.getServletContext().getRealPath(request.getServletPath());
        if (path == null) {
            throw new TransformerException("Stylesheet " + path + " not found");
        }
        Templates templates = (Templates)this.templatesCache.get(path);
        if (templates == null) {
            Map map = this.templatesCache;
            synchronized (map) {
                log.debug((Object)("Preparing new XSLT stylesheet: " + path));
                TransformerFactory factory = TransformerFactory.newInstance();
                templates = factory.newTemplates(new StreamSource(new File(path)));
                this.templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.templatesCache = new HashMap();
        this.xmlWalker = new XMLWalker();
        this.tfactory = TransformerFactory.newInstance();
        this.tfactory.setErrorListener(new ErrorListener(){

            public void error(TransformerException exception) throws TransformerException {
                log.error((Object)exception);
            }

            public void fatalError(TransformerException exception) throws TransformerException {
                log.fatal((Object)exception);
                throw exception;
            }

            public void warning(TransformerException exception) throws TransformerException {
                log.info((Object)("Warning: " + exception), (Throwable)exception);
            }
        });
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, MalformedURLException {
        try {
            Object result;
            long startTime = 0L;
            if (log.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((result = ValueStack.getStack((ServletRequest)request).findValue(".")) == null) {
                log.info((Object)"Warning: Request attribute \"webwork.result\" is null!");
                result = "Warning: Request attribute \"webwork.result\" is null!";
            }
            Templates templates = this.getTemplates(request);
            Transformer transformer = templates.newTransformer();
            String mimeType = templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            XMLReaderAdapter xmlResultAdapter = new XMLReaderAdapter(this.xmlWalker, result, ROOT_ELEMENT_NAME);
            SAXSource xmlSource = new SAXSource(xmlResultAdapter, new InputSource());
            PrintWriter out = response.getWriter();
            transformer.transform(xmlSource, new StreamResult(out));
            out.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time:" + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException("XSLT Transformation creation failed: " + e, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ServletException("XSLT Transformation failed: " + e, (Throwable)e);
        }
    }
}

