/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.swing.table.TableModel;
import org.apache.log4j.Category;
import webwork.util.BeanUtil;
import webwork.view.taglib.ui.ComponentTag;
import webwork.view.taglib.ui.table.SortFilterModel;
import webwork.view.taglib.ui.table.SortableTableModel;
import webwork.view.taglib.ui.table.WebTableColumn;
import webwork.view.taglib.ui.table.renderer.CellRenderer;

public class WebTable
extends ComponentTag {
    protected String _modelName = null;
    protected WebTableColumn[] _columns = null;
    protected TableModel _model = null;
    int _curRow = 0;
    protected boolean _sortable = false;

    public WebTable() {
        this.setTemplate("table.jsp");
    }

    public WebTable(TableModel model) {
        this.setModel(model);
    }

    public void addParameter(String name, Object value) {
        BeanUtil.setProperty(name, value, this);
        super.addParameter(name, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        if (!this._sortable || !(this._model instanceof SortableTableModel)) return super.doEndTag();
        Category.getInstance(this.getClass()).debug((Object)("we are looking for " + this.getSortColumnLinkName()));
        String sortColumn = ((TagSupport)this).pageContext.getRequest().getParameter(this.getSortColumnLinkName());
        String sortOrder = ((TagSupport)this).pageContext.getRequest().getParameter(this.getSortOrderLinkName());
        Category.getInstance(this.getClass()).debug((Object)("we have the sortColumn " + sortColumn));
        Category.getInstance(this.getClass()).debug((Object)("we have the sortOrder " + sortOrder));
        if (sortColumn != null) {
            try {
                int columnNumber = Integer.parseInt(sortColumn);
                if (columnNumber < 0) return super.doEndTag();
                ((SortableTableModel)this._model).sort(columnNumber, sortOrder);
                Category.getInstance(this.getClass()).debug((Object)"we just sorted the data");
                return super.doEndTag();
            }
            catch (Exception e) {
                Category.getInstance(this.getClass()).error((Object)e);
                throw new JspTagException("Error with WebTable: " + this.toString(e));
            }
        } else {
            Category.getInstance(this.getClass()).debug((Object)"the sort column is null.....skipping");
        }
        return super.doEndTag();
    }

    public WebTableColumn getColumn(int index) {
        try {
            return this._columns[index];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    public void getColumnDisplayName(int column) {
        this._columns[column].getDisplayName();
    }

    public CellRenderer getColumnRenderer(int column) {
        return this._columns[column].getRenderer();
    }

    public WebTableColumn[] getColumns() {
        return this._columns;
    }

    public String[] getFormattedRow(int row) {
        ArrayList<String> data = new ArrayList<String>(this.getNumberOfVisibleColumns());
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this._columns[i].isVisible()) {
                data.add(this._columns[i].getRenderer().renderCell(this, this._model.getValueAt(row, i), row, i));
            }
            ++i;
        }
        return data.toArray(new String[0]);
    }

    public TableModel getModel() {
        return this._model;
    }

    public String getModelName() {
        return this._modelName;
    }

    protected int getNumberOfVisibleColumns() {
        int count = 0;
        int i = 0;
        while (i < this._columns.length) {
            if (!this._columns[i].isHidden()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Object getRawData(int row, int column) {
        return this._model.getValueAt(row, column);
    }

    public Iterator getRawDataRowIterator() {
        return new WebTableRowIterator(this, 1);
    }

    public Object[] getRow(int row) {
        ArrayList<Object> data = new ArrayList<Object>(this.getNumberOfVisibleColumns());
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this._columns[i].isVisible()) {
                data.add(this._model.getValueAt(row, i));
            }
            ++i;
        }
        return data.toArray(new Object[0]);
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public Iterator getRowIterator() {
        return new WebTableRowIterator(this);
    }

    public int getSortColumn() {
        if (this._model instanceof SortableTableModel) {
            return ((SortableTableModel)this._model).getSortedColumnNumber();
        }
        return -1;
    }

    public String getSortColumnLinkName() {
        return "WEBTABLE_" + this._modelName + "_SORT_COLUMN";
    }

    public String getSortOrder() {
        if (this._model instanceof SortableTableModel && this.getSortColumn() >= 0) {
            return ((SortableTableModel)this._model).getSortedDirection(this.getSortColumn());
        }
        return "NONE";
    }

    public String getSortOrderLinkName() {
        return "WEBTABLE_" + this._modelName + "_SORT_ORDER";
    }

    public boolean isColumnHidden(int column) {
        return this._columns[column].isHidden();
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setColumnDisplayName(int column, String displayName) {
        this._columns[column].setDisplayName(displayName);
    }

    public void setColumnHidden(int column, boolean hide) {
        this._columns[column].setHidden(hide);
    }

    public void setColumnRenderer(int column, CellRenderer renderer) {
        this._columns[column].setRenderer(renderer);
    }

    public void setModel(TableModel model) {
        this._model = model;
        this._columns = new WebTableColumn[this._model.getColumnCount()];
        int i = 0;
        while (i < this._columns.length) {
            this._columns[i] = new WebTableColumn(this._model.getColumnName(i), i);
            ++i;
        }
        if (this._sortable && !(this._model instanceof SortableTableModel)) {
            this._model = new SortFilterModel(this._model);
        }
    }

    public void setModelName(String modelName) {
        this._modelName = (String)this.findValue(modelName);
        Object obj = this.findValue(this._modelName);
        if (obj instanceof TableModel) {
            this.setModel((TableModel)obj);
        }
    }

    public void setSortable(boolean sortable) {
        this._sortable = sortable;
        if (this._sortable && this._model != null && !(this._model instanceof SortableTableModel)) {
            this._model = new SortFilterModel(this._model);
        }
    }

    public class WebTableRowIterator
    implements Iterator {
        protected WebTable _table;
        protected int _curRow = 0;
        protected int _mode = 0;
        public static final int FORMATTED_DATA = 0;
        public static final int RAW_DATA = 1;

        protected WebTableRowIterator(WebTable table) {
            this(table, 0);
        }

        protected WebTableRowIterator(WebTable table, int mode) {
            this._table = table;
            this._mode = mode;
        }

        public boolean hasNext() {
            if (this._table == null) {
                return false;
            }
            return this._table.getRowCount() > this._curRow;
        }

        public Object next() throws NoSuchElementException {
            if (this._table == null) {
                throw new NoSuchElementException("WebTable is null");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("Beyond end of WebTable");
            }
            if (this._mode == 1) {
                return this._table.getRow(this._curRow++);
            }
            return this._table.getFormattedRow(this._curRow++);
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException("Remove not supported in WebTable");
        }
    }
}

