/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public abstract class IteratorFilterSupport {
    protected Object getIterator(Object source) {
        if (source instanceof Map) {
            source = ((Map)source).entrySet();
        } else if (source instanceof Collection) {
            source = ((Collection)source).iterator();
        } else if (source instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)source);
        }
        return source;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EnumerationIterator
    implements Iterator {
        Enumeration enum;

        public EnumerationIterator(Enumeration aEnum) {
            this.enum = aEnum;
        }

        public boolean hasNext() {
            return this.enum.hasMoreElements();
        }

        public Object next() {
            return this.enum.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in IteratorFilterSupport.");
        }
    }
}

