
## otest-shim

__otest-shim__ tricks OCUnit into outputting test results in structured
JSON rather than in plain text.  It also captures any stdout / stderr
output generated by individual tests.

Instead of writing plain text like this:

```
Test Suite
'/Users/fpotter/Library/Developer/Xcode/DerivedData/TestProject-Library-OSX-cdgcsjlcfmpqvnbvrmphsrtbqvhp/Build/Products/Debug/TestProject-Library-OSXTests.octest(Tests)' started at 2013-04-24 07:05:35 +0000
Test Suite 'TestProject_Library_OSXTests' started at 2013-04-24 07:05:35 +0000
Test Case '-[TestProject_Library_OSXTests testWillFail]' started.
/Users/fpotter/fb/git/fbobjc/Tools/xcodetool/xcodetool/xcodetool-tests/TestData/TestProject-Library-OSX/TestProject-Library-OSXTests/TestProject_Library_OSXTests.m:36:
error: -[TestProject_Library_OSXTests testWillFail] : '1' should be equal to '2': Not Equal!
Test Case '-[TestProject_Library_OSXTests testWillFail]' failed (0.000 seconds).
Test Case '-[TestProject_Library_OSXTests testWillPass]' started.
Test Case '-[TestProject_Library_OSXTests testWillPass]' passed (0.000 seconds).
Test Suite 'TestProject_Library_OSXTests' finished at 2013-04-24 07:05:35 +0000.
Executed 3 tests, with 1 failure (0 unexpected) in 0.001 (0.001) seconds Test Suite
'/Users/fpotter/Library/Developer/Xcode/DerivedData/TestProject-Library-OSX-cdgcsjlcfmpqvnbvrmphsrtbqvhp/Build/Products/Debug/TestProject-Library-OSXTests.octest(Tests)' finished at 2013-04-24 07:05:35 +0000.
Executed 3 tests, with 1 failure (0 unexpected) in 0.001 (0.002) seconds
```

It makes __otest__ output JSON events, one per line:

```
{"event":"begin-test-suite","suite":"\/Users\/fpotter\/Library\/Developer\/Xcode\/DerivedData\/TestProject-Library-OSX-cdgcsjlcfmpqvnbvrmphsrtbqvhp\/Build\/Products\/Debug\/TestProject-Library-OSXTests.octest(Tests)"}
{"event":"begin-test-suite","suite":"TestProject_Library_OSXTests"}
{"event":"begin-test","test":"-[TestProject_Library_OSXTests testWillFail]"}
{"succeeded":false,"test":"-[TestProject_Library_OSXTests testWillFail]","output":"","event":"end-test","totalDuration":6.002187728881836e-05,"exception":{"filePathInProject":"\/Users\/fpotter\/fb\/git\/fbobjc\/Tools\/xcodetool\/xcodetool\/xcodetool-tests\/TestData\/TestProject-Library-OSX\/TestProject-Library-OSXTests\/TestProject_Library_OSXTests.m","lineNumber":36,"reason":"'1' should be equal to '2': Not Equal!","name":"SenTestFailureException"}}
{"event":"begin-test","test":"-[TestProject_Library_OSXTests testWillPass]"}
{"succeeded":true,"test":"-[TestProject_Library_OSXTests testWillPass]","output":"","event":"end-test","totalDuration":2.503395080566406e-05}
{"suite":"TestProject_Library_OSXTests","testCaseCount":3,"event":"end-test-suite","totalFailureCount":1,"totalDuration":0.00157397985458374,"unexpectedExceptionCount":0,"testDuration":0.001401066780090332}
{"suite":"\/Users\/fpotter\/Library\/Developer\/Xcode\/DerivedData\/TestProject-Library-OSX-cdgcsjlcfmpqvnbvrmphsrtbqvhp\/Build\/Products\/Debug\/TestProject-Library-OSXTests.octest(Tests)","testCaseCount":3,"event":"end-test-suite","totalFailureCount":1,"totalDuration":0.001666009426116943,"unexpectedExceptionCount":0,"testDuration":0.001401066780090332}
```

### Usage

Here's an example of how you would load the shim when running an OCUnit
test bundle for OSX:

```
DYLD_INSERT_LIBRARIES=path/to/otest-shim-osx.dylib \
  OBJC_DISABLE_GC=YES \
  DYLD_LIBRARY_PATH=~/Library/Developer/Xcode/DerivedData/SomeProject-cdgcsjlcfmpqvnbvrmphsrtbqvhp/Build/Products/Debug/ \
  /Applications/Xcode.app//Contents/Developer/Tools/otest \
  ~/Library/Developer/Xcode/DerivedData/SomeProject-cdgcsjlcfmpqvnbvrmphsrtbqvhp/Build/Products/Debug/SomeProject-Tests.octest
```

Actual usage varies depending on whether you're targeting iOS or
Mac, or Logic or Application tests.

