//////////////////////////////////////////////////////////////////////////////
// Name:        CSSStyleDeclaration.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genCSS.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_CSS_STYLE_DECLARATION_H
#define WX_CSS_STYLE_DECLARATION_H


#include "CSSValue.h"
#include "SVGPaint.h"
#include "SVGAnimatedType.h"
#include <wx/hashmap.h>

enum wxCSS_PROPERTY
{
  wxCSS_PROPERTY_UNKNOWN,
  wxCSS_PROPERTY_ALIGNMENT_BASELINE,
  wxCSS_PROPERTY_BASELINE_SHIFT,
  wxCSS_PROPERTY_CLIP,
  wxCSS_PROPERTY_CLIP_PATH,
  wxCSS_PROPERTY_CLIP_RULE,
  wxCSS_PROPERTY_COLOR,
  wxCSS_PROPERTY_COLOR_INTERPOLATION,
  wxCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS,
  wxCSS_PROPERTY_COLOR_PROFILE,
  wxCSS_PROPERTY_COLOR_RENDERING,
  wxCSS_PROPERTY_CURSOR,
  wxCSS_PROPERTY_DIRECTION,
  wxCSS_PROPERTY_DISPLAY,
  wxCSS_PROPERTY_DOMINANT_BASELINE,
  wxCSS_PROPERTY_ENABLE_BACKGROUND,
  wxCSS_PROPERTY_FILL,
  wxCSS_PROPERTY_FILL_OPACITY,
  wxCSS_PROPERTY_FILL_RULE,
  wxCSS_PROPERTY_FILTER,
  wxCSS_PROPERTY_FLOOD_COLOR,
  wxCSS_PROPERTY_FLOOD_OPACITY,
  wxCSS_PROPERTY_FONT_FAMILY,
  wxCSS_PROPERTY_FONT_SIZE,
  wxCSS_PROPERTY_FONT_SIZE_ADJUST,
  wxCSS_PROPERTY_FONT_STRETCH,
  wxCSS_PROPERTY_FONT_STYLE,
  wxCSS_PROPERTY_FONT_VARIANT,
  wxCSS_PROPERTY_FONT_WEIGHT,
  wxCSS_PROPERTY_GLYPH_ORIENTATION_HORIZONTAL,
  wxCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL,
  wxCSS_PROPERTY_IMAGE_RENDERING,
  wxCSS_PROPERTY_KERNING,
  wxCSS_PROPERTY_LETTER_SPACING,
  wxCSS_PROPERTY_LIGHTING_COLOR,
  wxCSS_PROPERTY_MARKER_END,
  wxCSS_PROPERTY_MARKER_MID,
  wxCSS_PROPERTY_MARKER_START,
  wxCSS_PROPERTY_MASK,
  wxCSS_PROPERTY_OPACITY,
  wxCSS_PROPERTY_OVERFLOW,
  wxCSS_PROPERTY_POINTER_EVENTS,
  wxCSS_PROPERTY_SHAPE_RENDERING,
  wxCSS_PROPERTY_STOP_COLOR,
  wxCSS_PROPERTY_STOP_OPACITY,
  wxCSS_PROPERTY_STROKE,
  wxCSS_PROPERTY_STROKE_DASHARRAY,
  wxCSS_PROPERTY_STROKE_DASHOFFSET,
  wxCSS_PROPERTY_STROKE_LINECAP,
  wxCSS_PROPERTY_STROKE_LINEJOIN,
  wxCSS_PROPERTY_STROKE_MITERLIMIT,
  wxCSS_PROPERTY_STROKE_OPACITY,
  wxCSS_PROPERTY_STROKE_WIDTH,
  wxCSS_PROPERTY_TEXT_ANCHOR,
  wxCSS_PROPERTY_TEXT_DECORATION,
  wxCSS_PROPERTY_TEXT_RENDERING,
  wxCSS_PROPERTY_UNICODE_BIDI,
  wxCSS_PROPERTY_VISIBILITY,
  wxCSS_PROPERTY_WORD_SPACING,
  wxCSS_PROPERTY_WRITING_MODE
};

WX_DECLARE_HASH_MAP(wxCSS_PROPERTY, wxCSSValue*, wxIntegerHash, wxIntegerEqual, wxHashMapCSSValue);

typedef wxString wxCSSStyler;

class wxCSSStyleDeclaration: public wxHashMapCSSValue
{
  public:
    wxCSSStyleDeclaration() {}
    wxCSSStyleDeclaration(const wxCSSStyleDeclaration& src) { Add(src); }
    ~wxCSSStyleDeclaration();
    wxCSSStyleDeclaration& operator=(const wxCSSStyleDeclaration& src);
    void Add(const wxCSSStyleDeclaration& style);

  public:
    wxString GetCSSText() const;
    void SetCSSText(const wxString& text);
    
    inline wxString GetPropertyValue(const wxString& propertyName) const
    { return GetPropertyValue(GetPropertyId(propertyName)); }
    
    inline const wxCSSValue& GetPropertyCSSValue(const wxString& propertyName) const
    { return GetPropertyCSSValue(GetPropertyId(propertyName)); }
    
    void SetProperty(const wxString& propertyName, const wxString& value)
    { SetProperty(GetPropertyId(propertyName), value); }
    
    void SetProperty(const wxString& propertyName, const wxSVGAnimatedType& value)
    { SetProperty(GetPropertyId(propertyName), value); }
    
    inline bool HasProperty(const wxString& propertyName) const
    { return HasProperty(GetPropertyId(propertyName)); }
    
    inline wxString RemoveProperty(const wxString& propertyName)
    { return RemoveProperty(GetPropertyId(propertyName)); }
  
  public:
    inline wxString GetPropertyValue(wxCSS_PROPERTY propertyId) const
    { const_iterator it = find(propertyId); if (it != end()) return it->second->GetCSSText(); return wxT(""); }
    
    inline const wxCSSValue& GetPropertyCSSValue(wxCSS_PROPERTY propertyId) const
    { const_iterator it = find(propertyId); if (it != end()) return *it->second; return *s_emptyCSSValue; }
    
    void SetProperty(wxCSS_PROPERTY propertyId, const wxString& value);
    void SetProperty(wxCSS_PROPERTY propertyId, const wxSVGAnimatedType& value);
    inline bool HasProperty(wxCSS_PROPERTY propertyId) const { return find(propertyId) != end(); }
    inline wxString RemoveProperty(wxCSS_PROPERTY propertyId) { erase(propertyId); return wxT(""); }
    
    static wxCSS_PROPERTY GetPropertyId(const wxString& propertyName);
    static wxString GetPropertyName(wxCSS_PROPERTY propertyId);
  
  public:
    inline wxCSS_VALUE GetAlignmentBaseline() const
    {
      const_iterator it = find(wxCSS_PROPERTY_ALIGNMENT_BASELINE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasAlignmentBaseline() const { return HasProperty(wxCSS_PROPERTY_ALIGNMENT_BASELINE); }
    inline void SetAlignmentBaseline(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_ALIGNMENT_BASELINE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_ALIGNMENT_BASELINE] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetBaselineShift() const
    {
      const_iterator it = find(wxCSS_PROPERTY_BASELINE_SHIFT);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasBaselineShift() const { return HasProperty(wxCSS_PROPERTY_BASELINE_SHIFT); }
    inline void SetBaselineShift(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_BASELINE_SHIFT);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_BASELINE_SHIFT] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetClip() const
    {
      const_iterator it = find(wxCSS_PROPERTY_CLIP);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasClip() const { return HasProperty(wxCSS_PROPERTY_CLIP); }
    inline void SetClip(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_CLIP);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_CLIP] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetClipPath() const
    {
      const_iterator it = find(wxCSS_PROPERTY_CLIP_PATH);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasClipPath() const { return HasProperty(wxCSS_PROPERTY_CLIP_PATH); }
    inline void SetClipPath(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_CLIP_PATH);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_CLIP_PATH] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetClipRule() const
    {
      const_iterator it = find(wxCSS_PROPERTY_CLIP_RULE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NONZERO;
    }
    inline bool HasClipRule() const { return HasProperty(wxCSS_PROPERTY_CLIP_RULE); }
    inline void SetClipRule(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_CLIP_RULE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_CLIP_RULE] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxRGBColor GetColor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_COLOR);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetRGBColorValue() : wxRGBColor();
    }
    inline bool HasColor() const { return HasProperty(wxCSS_PROPERTY_COLOR); }
    inline void SetColor(const wxRGBColor& value)
    {
      iterator it = find(wxCSS_PROPERTY_COLOR);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetRGBColorValue(value);
      else
        (*this)[wxCSS_PROPERTY_COLOR] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetColorInterpolation() const
    {
      const_iterator it = find(wxCSS_PROPERTY_COLOR_INTERPOLATION);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_SRGB;
    }
    inline bool HasColorInterpolation() const { return HasProperty(wxCSS_PROPERTY_COLOR_INTERPOLATION); }
    inline void SetColorInterpolation(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_COLOR_INTERPOLATION);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_COLOR_INTERPOLATION] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetColorInterpolationFilters() const
    {
      const_iterator it = find(wxCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_LINEARRGB;
    }
    inline bool HasColorInterpolationFilters() const { return HasProperty(wxCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS); }
    inline void SetColorInterpolationFilters(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_COLOR_INTERPOLATION_FILTERS] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetColorProfile() const
    {
      const_iterator it = find(wxCSS_PROPERTY_COLOR_PROFILE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasColorProfile() const { return HasProperty(wxCSS_PROPERTY_COLOR_PROFILE); }
    inline void SetColorProfile(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_COLOR_PROFILE);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_COLOR_PROFILE] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetColorRendering() const
    {
      const_iterator it = find(wxCSS_PROPERTY_COLOR_RENDERING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasColorRendering() const { return HasProperty(wxCSS_PROPERTY_COLOR_RENDERING); }
    inline void SetColorRendering(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_COLOR_RENDERING);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_COLOR_RENDERING] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetCursor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_CURSOR);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasCursor() const { return HasProperty(wxCSS_PROPERTY_CURSOR); }
    inline void SetCursor(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_CURSOR);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_CURSOR] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetDirection() const
    {
      const_iterator it = find(wxCSS_PROPERTY_DIRECTION);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_LTR;
    }
    inline bool HasDirection() const { return HasProperty(wxCSS_PROPERTY_DIRECTION); }
    inline void SetDirection(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_DIRECTION);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_DIRECTION] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetDisplay() const
    {
      const_iterator it = find(wxCSS_PROPERTY_DISPLAY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_INLINE;
    }
    inline bool HasDisplay() const { return HasProperty(wxCSS_PROPERTY_DISPLAY); }
    inline void SetDisplay(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_DISPLAY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_DISPLAY] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetDominantBaseline() const
    {
      const_iterator it = find(wxCSS_PROPERTY_DOMINANT_BASELINE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasDominantBaseline() const { return HasProperty(wxCSS_PROPERTY_DOMINANT_BASELINE); }
    inline void SetDominantBaseline(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_DOMINANT_BASELINE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_DOMINANT_BASELINE] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetEnableBackground() const
    {
      const_iterator it = find(wxCSS_PROPERTY_ENABLE_BACKGROUND);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_ACCUMULATE;
    }
    inline bool HasEnableBackground() const { return HasProperty(wxCSS_PROPERTY_ENABLE_BACKGROUND); }
    inline void SetEnableBackground(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_ENABLE_BACKGROUND);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_ENABLE_BACKGROUND] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxSVGPaint& GetFill() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FILL);
      return it != end() ? ((wxSVGPaint&)*it->second) : *s_blackSVGPaint;
    }
    inline bool HasFill() const { return HasProperty(wxCSS_PROPERTY_FILL); }
    inline void SetFill(const wxSVGPaint& value)
    {
      iterator it = find(wxCSS_PROPERTY_FILL);
      if (it != end())
      {
        delete it->second;
        it->second = new wxSVGPaint(value);
      }
      else
        (*this)[wxCSS_PROPERTY_FILL] = new wxSVGPaint(value);
    }
    

    inline double GetFillOpacity() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FILL_OPACITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasFillOpacity() const { return HasProperty(wxCSS_PROPERTY_FILL_OPACITY); }
    inline void SetFillOpacity(double value)
    {
      iterator it = find(wxCSS_PROPERTY_FILL_OPACITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_FILL_OPACITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetFillRule() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FILL_RULE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NONZERO;
    }
    inline bool HasFillRule() const { return HasProperty(wxCSS_PROPERTY_FILL_RULE); }
    inline void SetFillRule(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_FILL_RULE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_FILL_RULE] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetFilter() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FILTER);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasFilter() const { return HasProperty(wxCSS_PROPERTY_FILTER); }
    inline void SetFilter(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_FILTER);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_FILTER] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxSVGColor& GetFloodColor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FLOOD_COLOR);
      return it != end() ? ((wxSVGColor&)*it->second) : *s_emptySVGColor;
    }
    inline bool HasFloodColor() const { return HasProperty(wxCSS_PROPERTY_FLOOD_COLOR); }
    inline void SetFloodColor(const wxSVGColor& value)
    {
      iterator it = find(wxCSS_PROPERTY_FLOOD_COLOR);
      if (it != end())
      {
        delete it->second;
        it->second = new wxSVGColor(value);
      }
      else
        (*this)[wxCSS_PROPERTY_FLOOD_COLOR] = new wxSVGColor(value);
    }
    

    inline double GetFloodOpacity() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FLOOD_OPACITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasFloodOpacity() const { return HasProperty(wxCSS_PROPERTY_FLOOD_OPACITY); }
    inline void SetFloodOpacity(double value)
    {
      iterator it = find(wxCSS_PROPERTY_FLOOD_OPACITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_FLOOD_OPACITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxString GetFontFamily() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_FAMILY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetStringValue() : wxT("");
    }
    inline bool HasFontFamily() const { return HasProperty(wxCSS_PROPERTY_FONT_FAMILY); }
    inline void SetFontFamily(const wxString& value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_FAMILY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetStringValue(wxCSS_STRING, value);
      else
        (*this)[wxCSS_PROPERTY_FONT_FAMILY] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetFontSize() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_SIZE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 20;
    }
    inline bool HasFontSize() const { return HasProperty(wxCSS_PROPERTY_FONT_SIZE); }
    inline void SetFontSize(double value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_SIZE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_FONT_SIZE] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetFontSizeAdjust() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_SIZE_ADJUST);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasFontSizeAdjust() const { return HasProperty(wxCSS_PROPERTY_FONT_SIZE_ADJUST); }
    inline void SetFontSizeAdjust(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_SIZE_ADJUST);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_FONT_SIZE_ADJUST] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetFontStretch() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_STRETCH);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NORMAL;
    }
    inline bool HasFontStretch() const { return HasProperty(wxCSS_PROPERTY_FONT_STRETCH); }
    inline void SetFontStretch(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_STRETCH);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_FONT_STRETCH] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetFontStyle() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_STYLE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NORMAL;
    }
    inline bool HasFontStyle() const { return HasProperty(wxCSS_PROPERTY_FONT_STYLE); }
    inline void SetFontStyle(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_STYLE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_FONT_STYLE] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetFontVariant() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_VARIANT);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NORMAL;
    }
    inline bool HasFontVariant() const { return HasProperty(wxCSS_PROPERTY_FONT_VARIANT); }
    inline void SetFontVariant(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_VARIANT);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_FONT_VARIANT] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetFontWeight() const
    {
      const_iterator it = find(wxCSS_PROPERTY_FONT_WEIGHT);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NORMAL;
    }
    inline bool HasFontWeight() const { return HasProperty(wxCSS_PROPERTY_FONT_WEIGHT); }
    inline void SetFontWeight(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_FONT_WEIGHT);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_FONT_WEIGHT] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetGlyphOrientationHorizontal() const
    {
      const_iterator it = find(wxCSS_PROPERTY_GLYPH_ORIENTATION_HORIZONTAL);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 0;
    }
    inline bool HasGlyphOrientationHorizontal() const { return HasProperty(wxCSS_PROPERTY_GLYPH_ORIENTATION_HORIZONTAL); }
    inline void SetGlyphOrientationHorizontal(double value)
    {
      iterator it = find(wxCSS_PROPERTY_GLYPH_ORIENTATION_HORIZONTAL);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_GLYPH_ORIENTATION_HORIZONTAL] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetGlyphOrientationVertical() const
    {
      const_iterator it = find(wxCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasGlyphOrientationVertical() const { return HasProperty(wxCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL); }
    inline void SetGlyphOrientationVertical(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_GLYPH_ORIENTATION_VERTICAL] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetImageRendering() const
    {
      const_iterator it = find(wxCSS_PROPERTY_IMAGE_RENDERING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasImageRendering() const { return HasProperty(wxCSS_PROPERTY_IMAGE_RENDERING); }
    inline void SetImageRendering(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_IMAGE_RENDERING);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_IMAGE_RENDERING] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetKerning() const
    {
      const_iterator it = find(wxCSS_PROPERTY_KERNING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasKerning() const { return HasProperty(wxCSS_PROPERTY_KERNING); }
    inline void SetKerning(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_KERNING);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_KERNING] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetLetterSpacing() const
    {
      const_iterator it = find(wxCSS_PROPERTY_LETTER_SPACING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasLetterSpacing() const { return HasProperty(wxCSS_PROPERTY_LETTER_SPACING); }
    inline void SetLetterSpacing(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_LETTER_SPACING);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_LETTER_SPACING] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxSVGColor& GetLightingColor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_LIGHTING_COLOR);
      return it != end() ? ((wxSVGColor&)*it->second) : *s_emptySVGColor;
    }
    inline bool HasLightingColor() const { return HasProperty(wxCSS_PROPERTY_LIGHTING_COLOR); }
    inline void SetLightingColor(const wxSVGColor& value)
    {
      iterator it = find(wxCSS_PROPERTY_LIGHTING_COLOR);
      if (it != end())
      {
        delete it->second;
        it->second = new wxSVGColor(value);
      }
      else
        (*this)[wxCSS_PROPERTY_LIGHTING_COLOR] = new wxSVGColor(value);
    }
    

    inline const wxCSSPrimitiveValue& GetMarkerEnd() const
    {
      const_iterator it = find(wxCSS_PROPERTY_MARKER_END);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasMarkerEnd() const { return HasProperty(wxCSS_PROPERTY_MARKER_END); }
    inline void SetMarkerEnd(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_MARKER_END);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_MARKER_END] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetMarkerMid() const
    {
      const_iterator it = find(wxCSS_PROPERTY_MARKER_MID);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasMarkerMid() const { return HasProperty(wxCSS_PROPERTY_MARKER_MID); }
    inline void SetMarkerMid(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_MARKER_MID);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_MARKER_MID] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetMarkerStart() const
    {
      const_iterator it = find(wxCSS_PROPERTY_MARKER_START);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasMarkerStart() const { return HasProperty(wxCSS_PROPERTY_MARKER_START); }
    inline void SetMarkerStart(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_MARKER_START);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_MARKER_START] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetMask() const
    {
      const_iterator it = find(wxCSS_PROPERTY_MASK);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasMask() const { return HasProperty(wxCSS_PROPERTY_MASK); }
    inline void SetMask(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_MASK);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_MASK] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetOpacity() const
    {
      const_iterator it = find(wxCSS_PROPERTY_OPACITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasOpacity() const { return HasProperty(wxCSS_PROPERTY_OPACITY); }
    inline void SetOpacity(double value)
    {
      iterator it = find(wxCSS_PROPERTY_OPACITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_OPACITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetOverflow() const
    {
      const_iterator it = find(wxCSS_PROPERTY_OVERFLOW);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasOverflow() const { return HasProperty(wxCSS_PROPERTY_OVERFLOW); }
    inline void SetOverflow(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_OVERFLOW);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_OVERFLOW] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetPointerEvents() const
    {
      const_iterator it = find(wxCSS_PROPERTY_POINTER_EVENTS);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_VISIBLEPAINTED;
    }
    inline bool HasPointerEvents() const { return HasProperty(wxCSS_PROPERTY_POINTER_EVENTS); }
    inline void SetPointerEvents(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_POINTER_EVENTS);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_POINTER_EVENTS] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetShapeRendering() const
    {
      const_iterator it = find(wxCSS_PROPERTY_SHAPE_RENDERING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasShapeRendering() const { return HasProperty(wxCSS_PROPERTY_SHAPE_RENDERING); }
    inline void SetShapeRendering(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_SHAPE_RENDERING);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_SHAPE_RENDERING] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxSVGColor& GetStopColor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STOP_COLOR);
      return it != end() ? ((wxSVGColor&)*it->second) : *s_emptySVGColor;
    }
    inline bool HasStopColor() const { return HasProperty(wxCSS_PROPERTY_STOP_COLOR); }
    inline void SetStopColor(const wxSVGColor& value)
    {
      iterator it = find(wxCSS_PROPERTY_STOP_COLOR);
      if (it != end())
      {
        delete it->second;
        it->second = new wxSVGColor(value);
      }
      else
        (*this)[wxCSS_PROPERTY_STOP_COLOR] = new wxSVGColor(value);
    }
    

    inline double GetStopOpacity() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STOP_OPACITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasStopOpacity() const { return HasProperty(wxCSS_PROPERTY_STOP_OPACITY); }
    inline void SetStopOpacity(double value)
    {
      iterator it = find(wxCSS_PROPERTY_STOP_OPACITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_STOP_OPACITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxSVGPaint& GetStroke() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE);
      return it != end() ? ((wxSVGPaint&)*it->second) : *s_emptySVGPaint;
    }
    inline bool HasStroke() const { return HasProperty(wxCSS_PROPERTY_STROKE); }
    inline void SetStroke(const wxSVGPaint& value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE);
      if (it != end())
      {
        delete it->second;
        it->second = new wxSVGPaint(value);
      }
      else
        (*this)[wxCSS_PROPERTY_STROKE] = new wxSVGPaint(value);
    }
    

    inline const wxCSSPrimitiveValue& GetStrokeDasharray() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_DASHARRAY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasStrokeDasharray() const { return HasProperty(wxCSS_PROPERTY_STROKE_DASHARRAY); }
    inline void SetStrokeDasharray(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_DASHARRAY);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_STROKE_DASHARRAY] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetStrokeDashoffset() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_DASHOFFSET);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 0;
    }
    inline bool HasStrokeDashoffset() const { return HasProperty(wxCSS_PROPERTY_STROKE_DASHOFFSET); }
    inline void SetStrokeDashoffset(double value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_DASHOFFSET);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_DASHOFFSET] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetStrokeLinecap() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_LINECAP);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_BUTT;
    }
    inline bool HasStrokeLinecap() const { return HasProperty(wxCSS_PROPERTY_STROKE_LINECAP); }
    inline void SetStrokeLinecap(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_LINECAP);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_LINECAP] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetStrokeLinejoin() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_LINEJOIN);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_MITER;
    }
    inline bool HasStrokeLinejoin() const { return HasProperty(wxCSS_PROPERTY_STROKE_LINEJOIN); }
    inline void SetStrokeLinejoin(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_LINEJOIN);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_LINEJOIN] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetStrokeMiterlimit() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_MITERLIMIT);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 4;
    }
    inline bool HasStrokeMiterlimit() const { return HasProperty(wxCSS_PROPERTY_STROKE_MITERLIMIT); }
    inline void SetStrokeMiterlimit(double value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_MITERLIMIT);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_MITERLIMIT] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetStrokeOpacity() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_OPACITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasStrokeOpacity() const { return HasProperty(wxCSS_PROPERTY_STROKE_OPACITY); }
    inline void SetStrokeOpacity(double value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_OPACITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_OPACITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline double GetStrokeWidth() const
    {
      const_iterator it = find(wxCSS_PROPERTY_STROKE_WIDTH);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetFloatValue() : 1;
    }
    inline bool HasStrokeWidth() const { return HasProperty(wxCSS_PROPERTY_STROKE_WIDTH); }
    inline void SetStrokeWidth(double value)
    {
      iterator it = find(wxCSS_PROPERTY_STROKE_WIDTH);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetFloatValue(wxCSS_NUMBER, value);
      else
        (*this)[wxCSS_PROPERTY_STROKE_WIDTH] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetTextAnchor() const
    {
      const_iterator it = find(wxCSS_PROPERTY_TEXT_ANCHOR);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_START;
    }
    inline bool HasTextAnchor() const { return HasProperty(wxCSS_PROPERTY_TEXT_ANCHOR); }
    inline void SetTextAnchor(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_TEXT_ANCHOR);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_TEXT_ANCHOR] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetTextDecoration() const
    {
      const_iterator it = find(wxCSS_PROPERTY_TEXT_DECORATION);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NONE;
    }
    inline bool HasTextDecoration() const { return HasProperty(wxCSS_PROPERTY_TEXT_DECORATION); }
    inline void SetTextDecoration(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_TEXT_DECORATION);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_TEXT_DECORATION] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetTextRendering() const
    {
      const_iterator it = find(wxCSS_PROPERTY_TEXT_RENDERING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_AUTO;
    }
    inline bool HasTextRendering() const { return HasProperty(wxCSS_PROPERTY_TEXT_RENDERING); }
    inline void SetTextRendering(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_TEXT_RENDERING);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_TEXT_RENDERING] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetUnicodeBidi() const
    {
      const_iterator it = find(wxCSS_PROPERTY_UNICODE_BIDI);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_NORMAL;
    }
    inline bool HasUnicodeBidi() const { return HasProperty(wxCSS_PROPERTY_UNICODE_BIDI); }
    inline void SetUnicodeBidi(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_UNICODE_BIDI);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_UNICODE_BIDI] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetVisibility() const
    {
      const_iterator it = find(wxCSS_PROPERTY_VISIBILITY);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_VISIBLE;
    }
    inline bool HasVisibility() const { return HasProperty(wxCSS_PROPERTY_VISIBILITY); }
    inline void SetVisibility(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_VISIBILITY);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_VISIBILITY] = new wxCSSPrimitiveValue(value);
    }
    

    inline const wxCSSPrimitiveValue& GetWordSpacing() const
    {
      const_iterator it = find(wxCSS_PROPERTY_WORD_SPACING);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second) : *s_emptyCSSValue;
    }
    inline bool HasWordSpacing() const { return HasProperty(wxCSS_PROPERTY_WORD_SPACING); }
    inline void SetWordSpacing(const wxCSSPrimitiveValue& value)
    {
      iterator it = find(wxCSS_PROPERTY_WORD_SPACING);
      if (it != end())
      {
        delete it->second;
        it->second = new wxCSSPrimitiveValue(value);
      }
      else
        (*this)[wxCSS_PROPERTY_WORD_SPACING] = new wxCSSPrimitiveValue(value);
    }
    

    inline wxCSS_VALUE GetWritingMode() const
    {
      const_iterator it = find(wxCSS_PROPERTY_WRITING_MODE);
      return it != end() ? ((wxCSSPrimitiveValue&)*it->second).GetIdentValue() : wxCSS_VALUE_LR_TB;
    }
    inline bool HasWritingMode() const { return HasProperty(wxCSS_PROPERTY_WRITING_MODE); }
    inline void SetWritingMode(wxCSS_VALUE value)
    {
      iterator it = find(wxCSS_PROPERTY_WRITING_MODE);
      if (it != end())
        ((wxCSSPrimitiveValue*)it->second)->SetIdentValue(value);
      else
        (*this)[wxCSS_PROPERTY_WRITING_MODE] = new wxCSSPrimitiveValue(value);
    }
    
  
  protected:
    static wxCSSPrimitiveValue* s_emptyCSSValue;
    static wxSVGColor* s_emptySVGColor;
    static wxSVGPaint* s_emptySVGPaint;
    static wxSVGPaint* s_blackSVGPaint;

  public:
    static double ParseNumber(const wxString& value);
    static wxRGBColor ParseColor(const wxString& value);
    static void ParseSVGPaint(wxSVGPaint& paint, const wxString& value);
};

/* this class copy only references of css values */
class wxCSSStyleRef: public wxCSSStyleDeclaration
{
  public:
    wxCSSStyleRef() {}
    wxCSSStyleRef(const wxCSSStyleDeclaration& src) { Add(src); }
    ~wxCSSStyleRef();
    void Add(const wxCSSStyleDeclaration& style);
};


#endif // WX_CSS_STYLE_DECLARATION_H
