/* wconfig_colorconf.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wconfig_colorconf.hh"
#include "wconfig.h"
#include "wc_color.hh"
#include "worker.h"

ColorConfPanel::ColorConfPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
  tempconfig = _baseconfig.duplicate();
  _last_color_size = tempconfig->getColors()->size();
}

ColorConfPanel::~ColorConfPanel()
{
  delete tempconfig;
}

int ColorConfPanel::create()
{
  int res;
  
  res = Panel::create();

  char buf[ A_BYTESFORNUMBER( int ) ];

  sprintf( buf, "%d", _baseconfig.getColors()->size() );

  AContainer *ac1 = setContainer( new AContainer( this, 1, 2 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  addMultiLineText( catalog.getLocale( 670 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );

  AContainer *ac1_1 = ac1->add( new AContainer( this, 2, 1 ), 0, 1 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  
  ac1_1->add( new Text( _aguix, 0, 0, catalog.getLocale( 14 ), 1 ),
              0, 0, AContainer::CFIX );
  
  sg = (StringGadget*)ac1_1->add( new StringGadget( _aguix, 0, 0, 30, buf, 0 ),
                                  1, 0, AContainer::CINCW );
  sg->connect( this );

  contMaximize( true );
  return 0;
}

int ColorConfPanel::saveValues()
{
  _baseconfig.setColors( tempconfig->getColors() );
  return 0;
}

void ColorConfPanel::run( Widget *elem, AGMessage &msg )
{
  List *colors = tempconfig->getColors();

  if ( msg.type == AG_STRINGGADGET_DEACTIVATE ) {
    if ( msg.stringgadget.sg == sg ) {
      int val = 0;
      sscanf( sg->getText(), "%d", &val );
      if ( ( val >= 8 ) && ( val <= 256 ) ) {
        while ( colors->size() < val ) colors->addElement( new WC_Color() );
        while ( colors->size() > val ) colors->removeLastElement();
        tempconfig->applyColorList( colors );
      } else {
        char *tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
        sprintf( tstr, "%d", colors->size() );
        sg->setText( tstr );
        _freesafe( tstr );
      }
    }
  }
}

void ColorConfPanel::hide()
{
  int color_size = tempconfig->getColors()->size();
  if ( color_size != _last_color_size ) {
    if ( _conf_cb != NULL )
      _conf_cb->setColors( tempconfig->getColors() );
    _last_color_size = color_size;
  }
  WConfigPanel::hide();
}

WConfigPanel::panel_action_t ColorConfPanel::setColors( List *colors )
{
  if ( colors != tempconfig->getColors() ) {
    tempconfig->setColors( colors );
  }

  return PANEL_NOACTION;
}
