#include <stdio.h>
#include <string.h>

#include "web.h"

int relative_url(char * newurl, const char * oldhost, 
		 int oldport, const char * oldfile, char * newhost,
		 int * newport, char * newfile, int alwaysget)
{
    char buf[512];
    int n;
    int getthis = options.bImageOverride ? alwaysget : 0;

    /* dreadful kludge to add a feature on top of a feature that was
       added as a bit of a hack anyway follows: */
    if (alwaysget == 0xF00) getthis = 1; /* magic override to override! */

    /* if the URL contains a protocol (and therefore site) spec: */
    if (!strchr(newurl, ':')) 
    {
	GetDirectory(oldfile, buf);
	ResolveRelative(buf, newurl, newfile);
	*newport = oldport;
	strcpy(newhost, oldhost);
	if (options.bVerbose >= 4)
	    printf("relative url: %s:%d/%s\n", newhost, *newport, newfile);
    }

    if (!strncmp(newurl, "http:", 5)) {

	if (SplitURL(newurl+7, newhost, newfile, newport))
	    return 1;
	
	if (!options.bFollowNone && !getthis && !strcmp(newhost, oldhost))
	    getthis = 1;
    }
    else if (strchr(newurl, ':'))
	return 1;			/* has a protocol other than http */

    sprintf(buf, "http://%s/%s http://%s/%d/%s", newhost, newfile, 
	    newhost, *newport, newfile);


    for (n = 0; !getthis && n < options.nNeverFollow; n++)
    {
	if (strstr(buf, options.pszNeverFollow[n]))
	    return 1;	/* never follow takes precedence */
    }

    if (!options.bFollowNone) return 0;

    for (n = 0; !getthis && n < options.nAlwaysFollow; n++)
    {
	if (strstr(buf, options.pszAlwaysFollow[n]))
	    getthis = 1;
    }

    if (!getthis) {
	if (options.bAsk) {
	    printf("Follow link to %s? [ny] ", newurl);
	    fflush(stdout);
	    fgets(buf, 256, stdin);
	    if (buf[0] == 'y' || buf[0] == 'Y') return 0;
	}

	if (options.fURLLog)
	    fprintf(options.fURLLog, "%s:%d/%s\n", 
		    newhost, *newport, newfile);
	
	return 1;
    }
    return 0;
}

/* www.somewhere.co.uk/local/file/address */

int SplitURL (char * pszUrl, char * pszHost, char * pszFile, int * pnPort)
{
    int		nPos = 0, n;
    char	* p;

    *pnPort = 80;

    p = pszHost, n = 1;
    if (* pszUrl == '/')
	return 1;
    while (pszUrl [nPos] && pszUrl [nPos] != '\r')
    {
	if (n == 1 && pszUrl [nPos] == ':')
	{
	    n = 2;
	    * p = 0;
	    nPos ++;
	    * pnPort = 0;
	    continue;
	}
	if (n == 1 && pszUrl [nPos] != '/')
	{
	    * (p ++) = pszUrl [nPos ++];
	    continue;
	}
	if (n == 1 && pszUrl [nPos] == '/')
	{
	    * p = 0;
	    nPos ++;
	    p = pszFile;
	    n = 0;
	    continue;
	}
	if (n == 2 && pszUrl [nPos] >= '0' && pszUrl[nPos] <= '9')
	{
	    *pnPort = (*pnPort * 10) + (int)(pszUrl[nPos++] - '0');
	    continue;
	}
	if (n == 2 && pszUrl [nPos] == '/')
	{
	    p = pszFile;
	    n = 0;
	    nPos ++;
	    continue;
	}
	if (n == 2)
	    return 1;		/* non numeric chars not allowed in port num */
	* (p ++) = pszUrl [nPos ++];
    }
    *p = 0;
    return 0;
}

